/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jain.protocol.ip.sip.header;

import com.ibm.ws.jain.protocol.ip.sip.header.HeaderImpl;
import com.ibm.ws.jain.protocol.ip.sip.header.ParameterQuoter;
import com.ibm.ws.jain.protocol.ip.sip.header.ParametersImpl;
import com.ibm.ws.sip.parser.SipParser;
import com.ibm.ws.sip.parser.util.CharsBuffer;
import jain.protocol.ip.sip.Parameters;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.header.ParametersHeader;
import java.util.Iterator;

public abstract class ParametersHeaderImpl
extends HeaderImpl
implements ParametersHeader,
Parameters {
    private static final long serialVersionUID = 7357153250876659997L;
    private ParametersImpl m_params = null;

    protected ParametersHeaderImpl() {
    }

    protected abstract char getListSeparator();

    protected abstract char getParamSeparator();

    protected boolean escapeParameters() {
        return true;
    }

    @Override
    public String getParameter(String name) throws IllegalArgumentException {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameter(name);
    }

    @Override
    public void setParameter(String name, String value) throws IllegalArgumentException, SipParseException {
        boolean quoted = false;
        boolean escapeParameters = this.escapeParameters();
        if (value != null && value.length() > 0) {
            ParameterQuoter quoter = ParameterQuoter.instance();
            quoted = quoter.quote(name, value, escapeParameters);
        }
        this.setParameter(name, value, quoted);
    }

    public void setParameter(String name, String value, boolean qouted) throws IllegalArgumentException, SipParseException {
        if (this.m_params == null) {
            this.m_params = new ParametersImpl();
        }
        this.m_params.setParameter(name, value, qouted);
    }

    @Override
    public boolean hasParameters() {
        return this.m_params != null && this.m_params.hasParameters();
    }

    @Override
    public boolean hasParameter(String name) throws IllegalArgumentException {
        return this.m_params != null && this.m_params.hasParameter(name);
    }

    @Override
    public void removeParameter(String name) throws IllegalArgumentException {
        if (this.m_params != null) {
            this.m_params.removeParameter(name);
        }
    }

    @Override
    public void removeParameters() {
        if (this.m_params != null) {
            this.m_params.removeParameters();
        }
    }

    @Override
    public Iterator getParameters() {
        if (this.m_params == null) {
            return null;
        }
        return this.m_params.getParameters();
    }

    @Override
    protected void parseValue(SipParser parser) throws SipParseException {
        char listSeparator = this.getListSeparator();
        if (parser.LA(1) == listSeparator) {
            parser.match(listSeparator);
            char paramSeparator = this.getParamSeparator();
            boolean escape = this.escapeParameters();
            this.m_params = parser.parseParametersMap(paramSeparator, escape, false);
        } else {
            this.removeParameters();
        }
    }

    @Override
    protected void encodeValue(CharsBuffer buffer) {
        if (this.m_params != null && this.m_params.size() > 0) {
            char listSeparator = this.getListSeparator();
            buffer.append(listSeparator);
            char paramSeparator = this.getParamSeparator();
            boolean escape = this.escapeParameters();
            this.m_params.encode(buffer, paramSeparator, escape);
        }
    }

    @Override
    protected boolean valueEquals(HeaderImpl other) {
        if (!(other instanceof ParametersHeaderImpl)) {
            return false;
        }
        ParametersHeaderImpl o = (ParametersHeaderImpl)other;
        if (this.m_params == null || this.m_params.size() == 0) {
            return o.m_params == null || o.m_params.size() == 0;
        }
        if (o.m_params == null || o.m_params.size() == 0) {
            return false;
        }
        return this.m_params.equals(o.m_params);
    }

    @Override
    public Object clone() {
        ParametersHeaderImpl ret = (ParametersHeaderImpl)super.clone();
        if (this.m_params != null) {
            ret.m_params = (ParametersImpl)this.m_params.clone();
        }
        return ret;
    }

    public void assign(ParametersHeaderImpl source) {
        this.m_params = source.m_params;
    }
}

