/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.plugins.custom;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.oauth20.token.OAuth20Token;
import com.ibm.oauth.core.util.JSONUtil;
import com.ibm.websphere.crypto.PasswordUtil;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.oauth20.store.OAuthStore;
import com.ibm.websphere.security.oauth20.store.OAuthStoreException;
import com.ibm.websphere.security.oauth20.store.OAuthToken;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20EnhancedTokenCache;
import com.ibm.ws.security.oauth20.plugins.OAuth20TokenImpl;
import com.ibm.ws.security.oauth20.util.CacheUtil;
import com.ibm.ws.security.oauth20.util.MessageDigestUtil;
import com.ibm.ws.security.oauth20.web.EndpointUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class OauthTokenStore
implements OAuth20EnhancedTokenCache {
    private static TraceComponent tc = Tr.register(OauthTokenStore.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private final String componentId;
    private final OAuthStore oauthStore;
    private Timer timer;
    private long cleanupIntervalInMilliseconds = 0L;
    private String accessTokenEncoding = "plain";
    int accessTokenLength;
    static final long serialVersionUID = -2008003845962852648L;

    public OauthTokenStore(String componentId, OAuthStore oauthStore, long cleanupIntervalInMilliseconds) {
        this.componentId = componentId;
        this.oauthStore = oauthStore;
        this.cleanupIntervalInMilliseconds = cleanupIntervalInMilliseconds;
    }

    public OauthTokenStore(String componentId, OAuthStore oauthStore, long cleanupIntervalInMilliseconds, String accessTokenEncoding, int accessTokenLength) {
        this.componentId = componentId;
        this.oauthStore = oauthStore;
        this.cleanupIntervalInMilliseconds = cleanupIntervalInMilliseconds;
        this.accessTokenEncoding = accessTokenEncoding;
        this.accessTokenLength = accessTokenLength;
    }

    @Override
    public void init(OAuthComponentConfiguration config) {
    }

    @Override
    public void initialize() {
        this.scheduleCleanupTask();
    }

    private void scheduleCleanupTask() {
        if (this.cleanupIntervalInMilliseconds > 0L) {
            long period;
            CleanupTask cleanupTask = new CleanupTask();
            this.timer = new Timer(true);
            long delay = period = this.cleanupIntervalInMilliseconds;
            this.timer.schedule((TimerTask)cleanupTask, delay, period);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(@Sensitive String lookupKeyParam, OAuth20Token entry, int lifetime) {
        block4: {
            String lookupKey = lookupKeyParam;
            boolean shouldHash = false;
            CacheUtil cacheUtil = new CacheUtil();
            if (cacheUtil.shouldHash(entry, this.accessTokenEncoding)) {
                shouldHash = true;
                lookupKey = cacheUtil.computeHash(lookupKeyParam, this.accessTokenEncoding);
            } else {
                lookupKey = MessageDigestUtil.getDigest(lookupKeyParam);
            }
            try {
                this.oauthStore.create(this.getOauthToken(lookupKey, entry, false, shouldHash));
            }
            catch (OAuthStoreException oAuthStoreException) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = entry;
                objectArray[2] = lifetime;
                FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"123", (Object)this, (Object[])objectArray);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block4;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_CREATE_TOKEN", (Object[])new Object[]{lookupKey, e.getLocalizedMessage()});
            }
        }
    }

    private OAuthToken getOauthToken(String lookupKey, OAuth20Token token, boolean alreadyHashed, boolean shouldHash) {
        String uniqueId = token.getId();
        String componentId = token.getComponentId();
        String type = token.getType();
        String subType = token.getSubType();
        long createdAt = token.getCreatedAt();
        int lifetimeInSeconds = token.getLifetimeSeconds();
        String tokenString = token.getTokenString();
        CacheUtil cacheUtil = new CacheUtil();
        if (!alreadyHashed) {
            if (shouldHash) {
                uniqueId = cacheUtil.computeHash(uniqueId, this.accessTokenEncoding);
                tokenString = cacheUtil.computeHash(tokenString, this.accessTokenEncoding);
            } else {
                tokenString = PasswordUtil.passwordEncode((String)tokenString);
            }
        }
        String clientId = token.getClientId();
        String username = token.getUsername();
        long expires = 0L;
        if (token.getLifetimeSeconds() > 0) {
            expires = token.getCreatedAt() + 1000L * (long)token.getLifetimeSeconds();
        }
        StringBuffer scopes = new StringBuffer();
        String[] ascopes = token.getScope();
        if (ascopes != null && ascopes.length > 0) {
            for (int i = 0; i < ascopes.length; ++i) {
                scopes.append(ascopes[i].trim());
                if (i >= ascopes.length - 1) continue;
                scopes.append(" ");
            }
        }
        String scope = scopes.toString();
        String redirectUri = token.getRedirectUri();
        String stateId = token.getStateId();
        JsonObject extendedFields = JSONUtil.getJsonObject(token.getExtensionProperties());
        if (extendedFields == null) {
            extendedFields = new JsonObject();
        }
        extendedFields.addProperty("grant_type", token.getGrantType());
        String refreshId = null;
        String accessId = null;
        if ("access_token".equals(token.getType())) {
            refreshId = ((OAuth20TokenImpl)token).getRefreshTokenKey();
            if (refreshId != null) {
                extendedFields.addProperty("refresh_token_id", refreshId);
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Access Token is added to cache , refresh token id " + refreshId), (Object[])new Object[0]);
                }
            }
        } else if ("id_token".equals(token.getType()) && (accessId = ((OAuth20TokenImpl)token).getAccessTokenKey()) != null) {
            extendedFields.addProperty("access_token_id", accessId);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("ID Token is added to cache , access token id " + accessId), (Object[])new Object[0]);
            }
        }
        String tokenProperties = extendedFields.toString();
        return new OAuthToken(lookupKey, uniqueId, componentId, type, subType, createdAt, lifetimeInSeconds, expires, tokenString, clientId, username, scope, redirectUri, stateId, tokenProperties);
    }

    @Override
    public OAuth20Token get(@Sensitive String lookupKey) {
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        }
        return this.getByHash(hash);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public OAuth20Token getByHash(String hash) {
        OAuth20Token token;
        block4: {
            token = null;
            try {
                OAuthToken oauthToken = this.oauthStore.readToken(this.componentId, hash);
                if (oauthToken != null) {
                    token = this.createToken(oauthToken);
                }
            }
            catch (OAuthStoreException oAuthStoreException) {
                void e;
                FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"228", (Object)this, (Object[])new Object[]{hash});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block4;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_READ_TOKEN", (Object[])new Object[]{hash, e.getLocalizedMessage()});
            }
        }
        if (token != null) {
            token.setLastAccess();
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    private OAuth20Token createToken(OAuthToken oauthToken) {
        OAuth20TokenImpl token;
        block20: {
            boolean isAuthorizationGrantTypeAndCodeSubType;
            token = null;
            String uniqueId = oauthToken.getUniqueId();
            String componentId = oauthToken.getProviderId();
            String type = oauthToken.getType();
            String subType = oauthToken.getSubType();
            long createdAt = oauthToken.getCreatedAt();
            int lifetime = oauthToken.getLifetimeInSeconds();
            long expires = oauthToken.getExpires();
            String tokenString = oauthToken.getTokenString();
            String clientId = oauthToken.getClientId();
            String username = oauthToken.getUsername();
            String scope = oauthToken.getScope();
            String[] scopes = null;
            if (scope != null) {
                scopes = scope.split(" ");
            }
            String redirectUri = oauthToken.getRedirectUri();
            String stateId = oauthToken.getStateId();
            JsonObject extendedFields = new JsonParser().parse(oauthToken.getTokenProperties()).getAsJsonObject();
            String grantType = null;
            String refreshId = null;
            String accessId = null;
            if (extendedFields != null) {
                grantType = extendedFields.get("grant_type").getAsString();
                if ("access_token".equals(type)) {
                    if (extendedFields.get("refresh_token_id") != null) {
                        refreshId = extendedFields.get("refresh_token_id").getAsString();
                    }
                } else if ("id_token".equals(type)) {
                    if (extendedFields.get("access_token_id") != null) {
                        accessId = extendedFields.get("access_token_id").getAsString();
                    } else if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Type is " + type + " but " + "access_token_id" + " from extended fields was null. " + extendedFields), (Object[])new Object[0]);
                    }
                }
                extendedFields.remove("grant_type");
                extendedFields.remove("refresh_token_id");
                extendedFields.remove("access_token_id");
            }
            boolean isAppPasswordOrAppTokenGT = "app_password".equals(grantType) || "app_token".equals(grantType);
            boolean bl = isAuthorizationGrantTypeAndCodeSubType = "authorization_grant".equals(type) && "authorization_code".equals(subType);
            if (isAuthorizationGrantTypeAndCodeSubType || !isAppPasswordOrAppTokenGT && "plain".equals(this.accessTokenEncoding)) {
                tokenString = PasswordUtil.passwordDecode((String)tokenString);
            }
            Map<String, String[]> extensionProperties = JSONUtil.jsonObjectToStringsMap(extendedFields);
            Date now = new Date();
            if (now.getTime() < expires) {
                token = new OAuth20TokenImpl(uniqueId, componentId, type, subType, createdAt, lifetime, tokenString, clientId, username, scopes, redirectUri, stateId, extensionProperties, grantType);
                if (refreshId != null) {
                    token.setRefreshTokenKey(refreshId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Got the Access Token from cache, refresh token id = " + refreshId), (Object[])new Object[0]);
                    }
                } else if (accessId != null) {
                    token.setAccessTokenKey(accessId);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Got the ID Token from cache, access token id = " + accessId), (Object[])new Object[0]);
                    }
                }
            } else {
                try {
                    throw new Exception("The OAuth20Token is expired already");
                }
                catch (Exception exception) {
                    void e;
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"316", (Object)this, (Object[])new Object[]{oauthToken});
                    if (!tc.isDebugEnabled()) break block20;
                    Tr.debug((TraceComponent)tc, (String)("Internal error ceating token :" + e.getMessage()), (Object[])new Object[]{e});
                }
            }
        }
        if (token != null) {
            token.setLastAccess();
        }
        return token;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<OAuth20Token> getAllUserTokens(String username) {
        try {
            return this.createTokens(this.oauthStore.readAllTokens(this.componentId, username));
        }
        catch (OAuthStoreException oAuthStoreException) {
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"333", (Object)this, (Object[])new Object[]{username});
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                void e;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_READ_ALL_TOKENS", (Object[])new Object[]{e.getLocalizedMessage()});
            }
            return Collections.emptyList();
        }
    }

    @Override
    public Collection<OAuth20Token> getAll() {
        return Collections.emptyList();
    }

    private Collection<OAuth20Token> createTokens(Collection<OAuthToken> oauthTokens) {
        ArrayList<OAuth20Token> tokens = new ArrayList<OAuth20Token>();
        if (oauthTokens != null) {
            for (OAuthToken oauthToken : oauthTokens) {
                OAuth20Token token = this.createToken(oauthToken);
                tokens.add(token);
            }
        }
        return tokens;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int getNumTokens(String username, String client) {
        try {
            return this.oauthStore.countTokens(this.componentId, username, client);
        }
        catch (OAuthStoreException oAuthStoreException) {
            FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"365", (Object)this, (Object[])new Object[]{username, client});
            if (TraceComponent.isAnyTracingEnabled() && tc.isErrorEnabled()) {
                void e;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_COUNT_TOKENS", (Object[])new Object[]{e.getLocalizedMessage()});
            }
            return 0;
        }
    }

    @Override
    public void remove(@Sensitive String lookupKey) {
        String hash = lookupKey;
        if (!PasswordUtil.isHashed((String)hash)) {
            hash = !"plain".equals(this.accessTokenEncoding) || lookupKey.length() == this.accessTokenLength + 2 ? ("plain".equals(this.accessTokenEncoding) ? EndpointUtils.computeTokenHash(lookupKey) : EndpointUtils.computeTokenHash(lookupKey, this.accessTokenEncoding)) : MessageDigestUtil.getDigest(lookupKey);
        }
        this.removeByHash(hash);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void removeByHash(String hash) {
        block2: {
            try {
                this.oauthStore.deleteToken(this.componentId, hash);
            }
            catch (OAuthStoreException oAuthStoreException) {
                void e;
                FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"397", (Object)this, (Object[])new Object[]{hash});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block2;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_DELETE_TOKEN", (Object[])new Object[]{hash, e.getLocalizedMessage()});
            }
        }
    }

    @Override
    public void stopCleanupThread() {
        if (this.timer != null) {
            this.timer.cancel();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addByHash(@Sensitive String hash, OAuth20Token entry, int lifetime) {
        block2: {
            String lookupKey = hash;
            try {
                this.oauthStore.create(this.getOauthToken(lookupKey, entry, true, false));
            }
            catch (OAuthStoreException oAuthStoreException) {
                void e;
                Object[] objectArray = new Object[3];
                objectArray[0] = "<sensitive java.lang.String>";
                objectArray[1] = entry;
                objectArray[2] = lifetime;
                FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"435", (Object)this, (Object[])objectArray);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block2;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_CREATE_TOKEN", (Object[])new Object[]{lookupKey, e.getLocalizedMessage()});
            }
        }
    }

    @Override
    public Collection<OAuth20Token> getMatchingTokens(String username, String client, String tokenType) {
        Collection<OAuth20Token> tokens = this.getUserAndClientTokens(username, client);
        if (tokens != null && !tokens.isEmpty()) {
            return OauthTokenStore.getTokensMatchingType(tokens, tokenType);
        }
        return Collections.emptyList();
    }

    private static Collection<OAuth20Token> getTokensMatchingClientId(Collection<OAuth20Token> tokens, String clientId) {
        Iterator<OAuth20Token> it = tokens.iterator();
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        while (it.hasNext()) {
            OAuth20Token token = it.next();
            if (!clientId.equals(token.getClientId())) continue;
            matchingTokens.add(token);
        }
        return matchingTokens;
    }

    private static Collection<OAuth20Token> getTokensMatchingType(Collection<OAuth20Token> tokens, String stateId) {
        Iterator<OAuth20Token> it = tokens.iterator();
        HashSet<OAuth20Token> matchingTokens = new HashSet<OAuth20Token>();
        while (it.hasNext()) {
            OAuth20Token token = it.next();
            if (!token.getStateId().equals(stateId)) continue;
            matchingTokens.add(token);
        }
        return matchingTokens;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<OAuth20Token> getUserAndClientTokens(String username, String client) {
        block3: {
            try {
                Collection<OAuth20Token> tokens = this.createTokens(this.oauthStore.readAllTokens(this.componentId, username));
                if (tokens != null && !tokens.isEmpty()) {
                    return OauthTokenStore.getTokensMatchingClientId(tokens, client);
                }
            }
            catch (OAuthStoreException tokens) {
                void e;
                FFDCFilter.processException((Throwable)tokens, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore", (String)"500", (Object)this, (Object[])new Object[]{username, client});
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block3;
                Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_READ_ALL_TOKENS", (Object[])new Object[]{e.getLocalizedMessage()});
            }
        }
        return Collections.emptyList();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class CleanupTask
    extends TimerTask {
        static final long serialVersionUID = -3461699394986553976L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private CleanupTask() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void run() {
            block2: {
                try {
                    OauthTokenStore.this.oauthStore.deleteTokens(OauthTokenStore.this.componentId, new Date().getTime());
                }
                catch (OAuthStoreException oAuthStoreException) {
                    void e;
                    FFDCFilter.processException((Throwable)oAuthStoreException, (String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore$CleanupTask", (String)"419", (Object)this, (Object[])new Object[0]);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isErrorEnabled()) break block2;
                    Tr.error((TraceComponent)tc, (String)"ERROR_PERFORMING_OAUTH_STORE_DELETE_TOKENS", (Object[])new Object[]{e.getLocalizedMessage()});
                }
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.plugins.custom.OauthTokenStore$CleanupTask", CleanupTask.class, null, null);
        }
    }
}

