/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util;

import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import com.arjuna.common.logging.commonLogger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class ClassloadingUtility {
    private static final char BREAKCHARACTER = ';';

    public static Class loadClass(String className) {
        Class<?> clazz;
        try {
            clazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            commonLogger.i18NLogger.warn_common_ClassloadingUtility_2(className, (Throwable)e);
            return null;
        }
        return clazz;
    }

    public static <T> Class<? extends T> loadClass(Class<T> iface, String className) {
        if (commonLogger.logger.isTraceEnabled()) {
            commonLogger.logger.trace((Object)("Loading class " + className));
        }
        if (className == null) {
            commonLogger.i18NLogger.warn_common_ClassloadingUtility_1();
            return null;
        }
        Class clazz = ClassloadingUtility.loadClass((String)className);
        if (clazz == null) {
            return null;
        }
        try {
            Class<T> clazz2 = clazz.asSubclass(iface);
            return clazz2;
        }
        catch (ClassCastException e) {
            commonLogger.i18NLogger.warn_common_ClassloadingUtility_3(className, iface.getName(), (Throwable)e);
            return null;
        }
    }

    public static <T> T loadAndInstantiateClass(Class<T> iface, String className, String environmentBeanInstanceName) {
        T instance = null;
        try {
            Class clazz = ClassloadingUtility.loadClass(iface, (String)className);
            if (clazz == null) {
                return null;
            }
            Constructor<?>[] ctors = clazz.getConstructors();
            Class<?> environmentBeanClass = null;
            for (Constructor<?> constructor : ctors) {
                if (constructor.getParameterTypes().length != 1 || !constructor.getParameterTypes()[0].getCanonicalName().endsWith("EnvironmentBean")) continue;
                environmentBeanClass = constructor.getParameterTypes()[0];
                Object envBean = BeanPopulator.getNamedInstance(environmentBeanClass, (String)environmentBeanInstanceName);
                instance = (T)constructor.newInstance(envBean);
                break;
            }
            if (environmentBeanClass == null && environmentBeanInstanceName == null) {
                instance = clazz.newInstance();
            }
        }
        catch (InstantiationException e) {
            commonLogger.i18NLogger.warn_common_ClassloadingUtility_4(className, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            commonLogger.i18NLogger.warn_common_ClassloadingUtility_5(className, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            commonLogger.i18NLogger.warn_common_ClassloadingUtility_4(className, (Throwable)e);
        }
        return instance;
    }

    public static <T> List<T> loadAndInstantiateClasses(Class<T> iface, List<String> classNames) {
        ArrayList<Object> instances = new ArrayList<Object>();
        if (classNames != null) {
            for (String className : classNames) {
                Object instance = ClassloadingUtility.loadAndInstantiateClass(iface, (String)className, null);
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        return instances;
    }

    public static <T> List<T> loadAndInstantiateClassesWithInit(Class<T> iface, List<String> classNamesWithOptionalInitParams) {
        ArrayList<Object> instances = new ArrayList<Object>();
        if (classNamesWithOptionalInitParams != null) {
            for (String theClassAndParameter : classNamesWithOptionalInitParams) {
                int breakPosition = theClassAndParameter.indexOf(59);
                String theClass = null;
                String theParameter = null;
                if (breakPosition != -1) {
                    theClass = theClassAndParameter.substring(0, breakPosition);
                    theParameter = theClassAndParameter.substring(breakPosition + 1);
                } else {
                    theClass = theClassAndParameter;
                }
                Object instance = ClassloadingUtility.loadAndInstantiateClass(iface, (String)theClass, null);
                if (theClass != null && theParameter != null) {
                    try {
                        Method method = instance.getClass().getMethod("initialise", String.class);
                        method.invoke(instance, theParameter);
                    }
                    catch (Exception e) {
                        commonLogger.i18NLogger.warn_common_ClassloadingUtility_6(theClassAndParameter, (Throwable)e);
                        continue;
                    }
                }
                if (instance == null) continue;
                instances.add(instance);
            }
        }
        return instances;
    }

    public static String getNameForClass(Object instance) {
        if (instance == null) {
            return null;
        }
        return instance.getClass().getName();
    }

    public static List<String> getNamesForClasses(List<? extends Object> instances) {
        ArrayList<String> names = new ArrayList<String>();
        if (instances != null) {
            for (Object object : instances) {
                String name = ClassloadingUtility.getNameForClass((Object)object);
                if (name == null) continue;
                names.add(name);
            }
        }
        return names;
    }
}

