/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.arjuna.objectstore.LogPurger;
import com.arjuna.ats.internal.arjuna.objectstore.LogStore;
import java.util.Collection;
import java.util.HashMap;

class LogPurger
extends Thread {
    public static final long DEFAULT_PURGE_TIME = 100000L;
    private HashMap<Uid, LogElement> _entries = new HashMap();
    private long _purgeTime;
    private LogStore _objStore;
    private Status _status;
    private Object _lock = new Object();

    public LogPurger(LogStore instance) {
        this(instance, 100000L);
    }

    public LogPurger(LogStore instance, long purgeTime) {
        super("Log Purger");
        this._objStore = instance;
        this._purgeTime = purgeTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRemovedState(Uid u, String tn, int state) {
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            this._entries.put(u, new LogElement(this, tn, u, state));
        }
    }

    public void purge() {
        try {
            this._objStore.truncateLogs(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeRemovalEntries() {
        HashMap hashMap = this._entries;
        synchronized (hashMap) {
            if (this._entries.size() > 0) {
                Collection entries = this._entries.values();
                for (LogElement val : entries) {
                    try {
                        this._objStore.removeState(val.uid, val.tn, val.state);
                    }
                    catch (Exception exception) {}
                }
                this._entries.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void trigger() {
        Object object = this._lock;
        synchronized (object) {
            if (this._status == Status.PASSIVE) {
                this._lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (true) {
            try {
                Object object = this._lock;
                synchronized (object) {
                    this._status = Status.PASSIVE;
                    this._lock.wait(this._purgeTime);
                }
            }
            catch (Exception ex) {
                this._status = Status.ACTIVE;
            }
            this.writeRemovalEntries();
            try {
                this._objStore.truncateLogs();
            }
            catch (Exception exception) {
            }
        }
    }
}

