/*
 * Decompiled with CFR 0.152.
 */
package jakarta.data.expression;

import jakarta.data.expression.ComparableExpression;
import jakarta.data.spi.expression.function.NumericCast;
import jakarta.data.spi.expression.function.NumericFunctionExpression;
import jakarta.data.spi.expression.function.NumericOperatorExpression;
import java.math.BigDecimal;
import java.math.BigInteger;

public interface NumericExpression<T, N extends Number>
extends ComparableExpression<T, N> {
    default public NumericExpression<T, N> abs() {
        return NumericFunctionExpression.of("abs", this);
    }

    default public NumericExpression<T, BigDecimal> asBigDecimal() {
        return NumericCast.of(this, BigDecimal.class);
    }

    default public NumericExpression<T, BigInteger> asBigInteger() {
        return NumericCast.of(this, BigInteger.class);
    }

    default public NumericExpression<T, Double> asDouble() {
        return NumericCast.of(this, Double.class);
    }

    default public NumericExpression<T, Long> asLong() {
        return NumericCast.of(this, Long.class);
    }

    default public NumericExpression<T, N> dividedBy(N divisor) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.DIVIDE, this, divisor);
    }

    default public NumericExpression<T, N> dividedBy(NumericExpression<? super T, N> divisorExpression) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.DIVIDE, this, divisorExpression);
    }

    default public NumericExpression<T, N> dividedInto(N value) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.DIVIDE, value, this);
    }

    default public NumericExpression<T, N> minus(N value) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.MINUS, this, value);
    }

    default public NumericExpression<T, N> minus(NumericExpression<? super T, N> expression) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.MINUS, this, expression);
    }

    default public NumericExpression<T, N> negated() {
        return NumericFunctionExpression.of("-", this);
    }

    default public NumericExpression<T, N> plus(N value) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.PLUS, this, value);
    }

    default public NumericExpression<T, N> plus(NumericExpression<? super T, N> expression) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.PLUS, this, expression);
    }

    default public NumericExpression<T, N> subtractedFrom(N value) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.MINUS, value, this);
    }

    default public NumericExpression<T, N> times(N factor) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.TIMES, this, factor);
    }

    default public NumericExpression<T, N> times(NumericExpression<? super T, N> factorExpression) {
        return NumericOperatorExpression.of(NumericOperatorExpression.Operator.TIMES, this, factorExpression);
    }
}

