/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.annotations.Tool;
import io.openliberty.mcp.internal.schemas.JsonProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ClassProperty
implements JsonProperty {
    private static final Tool.Annotations[] EMPTY_ANNOTATIONS;
    private String elementName;
    private Field field;
    private Method setter;
    private Method getGetter;
    private Method isGetter;
    static final long serialVersionUID = -9176063607697121719L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public ClassProperty(String name) {
        this.elementName = name;
    }

    @Override
    public String getElementName() {
        return this.elementName;
    }

    @Override
    public boolean isInput() {
        if (this.setter != null && JsonProperty.isTransient(this.setter)) {
            return false;
        }
        if (this.field != null && JsonProperty.isTransient(this.field)) {
            return false;
        }
        if (this.setter != null) {
            return Modifier.isPublic(this.setter.getModifiers());
        }
        if (this.field != null) {
            return Modifier.isPublic(this.field.getModifiers());
        }
        return false;
    }

    @Override
    public boolean isOutput() {
        Method getter = this.getGetter();
        if (getter != null && JsonProperty.isTransient(getter)) {
            return false;
        }
        if (this.field != null && JsonProperty.isTransient(this.field)) {
            return false;
        }
        if (getter != null) {
            return Modifier.isPublic(getter.getModifiers());
        }
        if (this.field != null) {
            return Modifier.isPublic(this.field.getModifiers());
        }
        return false;
    }

    @Override
    public String getInputName() {
        String name = JsonProperty.getNameFromAnnotations(this.setter);
        if (name == null) {
            name = JsonProperty.getNameFromAnnotations(this.field);
        }
        if (name == null) {
            name = this.elementName;
        }
        return name;
    }

    @Override
    public String getOutputName() {
        String name = JsonProperty.getNameFromAnnotations(this.getGetter());
        if (name == null) {
            name = JsonProperty.getNameFromAnnotations(this.field);
        }
        if (name == null) {
            name = this.elementName;
        }
        return name;
    }

    @Override
    public Type getInputType() {
        if (this.setter != null) {
            return this.setter.getGenericParameterTypes()[0];
        }
        if (this.field != null) {
            return this.field.getGenericType();
        }
        return Object.class;
    }

    @Override
    public Type getOutputType() {
        Method getter = this.getGetter();
        if (getter != null) {
            return getter.getGenericReturnType();
        }
        if (this.field != null) {
            return this.field.getGenericType();
        }
        return Object.class;
    }

    @Override
    public Annotation[] getInputAnnotations() {
        if (this.setter != null) {
            if (this.field != null) {
                return ClassProperty.combineAnnotations(this.setter, this.field);
            }
            return this.setter.getAnnotations();
        }
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        return EMPTY_ANNOTATIONS;
    }

    @Override
    public Annotation[] getOutputAnnotations() {
        Method getter = this.getGetter();
        if (getter != null) {
            if (this.field != null) {
                return ClassProperty.combineAnnotations(getter, this.field);
            }
            return getter.getAnnotations();
        }
        if (this.field != null) {
            return this.field.getAnnotations();
        }
        return EMPTY_ANNOTATIONS;
    }

    public Field getField() {
        return this.field;
    }

    public void addField(Field field) {
        if (this.field == null) {
            this.field = field;
        }
    }

    public Method getSetter() {
        return this.setter;
    }

    public void addSetter(Method setter) {
        if (this.setter == null) {
            this.setter = setter;
        }
    }

    public Method getGetter() {
        return this.getGetter != null ? this.getGetter : this.isGetter;
    }

    public void addGetGetter(Method getGetter) {
        if (this.getGetter == null) {
            this.getGetter = getGetter;
        }
    }

    public void addIsGetter(Method isGetter) {
        if (this.isGetter == null) {
            this.isGetter = isGetter;
        }
    }

    public static List<JsonProperty> extractFromClass(Class<?> cls) {
        Class<?> current;
        HashMap<String, ClassProperty> properties = new HashMap<String, ClassProperty>();
        for (current = cls; current != null && current != Object.class; current = current.getSuperclass()) {
            for (AnnotatedElement annotatedElement : current.getDeclaredFields()) {
                if (Modifier.isStatic(((Field)annotatedElement).getModifiers())) continue;
                properties.computeIfAbsent(((Field)annotatedElement).getName(), n -> new ClassProperty((String)n)).addField((Field)annotatedElement);
            }
            for (AnnotatedElement annotatedElement : current.getDeclaredMethods()) {
                if (Modifier.isStatic(((Method)annotatedElement).getModifiers())) continue;
                ClassProperty.processMethod((Method)annotatedElement, properties);
            }
        }
        for (current = cls; current != null && current != Object.class; current = current.getSuperclass()) {
            for (AnnotatedElement annotatedElement : current.getInterfaces()) {
                ClassProperty.processInterface(annotatedElement, properties);
            }
        }
        return new ArrayList<JsonProperty>(properties.values());
    }

    private static void processMethod(Method method, Map<String, ClassProperty> properties) {
        if (ClassProperty.isGetGetter(method)) {
            String name = ClassProperty.removeCamelCasePrefix(method.getName(), 3);
            properties.computeIfAbsent(name, ClassProperty::new).addGetGetter(method);
        } else if (ClassProperty.isIsGetter(method)) {
            String name = ClassProperty.removeCamelCasePrefix(method.getName(), 2);
            properties.computeIfAbsent(name, ClassProperty::new).addIsGetter(method);
        } else if (ClassProperty.isSetter(method)) {
            String name = ClassProperty.removeCamelCasePrefix(method.getName(), 3);
            properties.computeIfAbsent(name, ClassProperty::new).addSetter(method);
        }
    }

    private static void processInterface(Class<?> iface, Map<String, ClassProperty> properties) {
        for (Method method : iface.getDeclaredMethods()) {
            if (!method.isDefault()) continue;
            ClassProperty.processMethod(method, properties);
        }
        for (GenericDeclaration genericDeclaration : iface.getInterfaces()) {
            ClassProperty.processInterface(genericDeclaration, properties);
        }
    }

    private static boolean isSetter(Method method) {
        String name = method.getName();
        return method.getReturnType() == Void.TYPE && name.startsWith("set") && name.length() > 3 && method.getParameterCount() == 1 && !Modifier.isStatic(method.getModifiers());
    }

    private static boolean isGetGetter(Method method) {
        String name = method.getName();
        return name.startsWith("get") && name.length() > 3 && method.getReturnType() != Void.TYPE && method.getParameterCount() == 0 && !Modifier.isStatic(method.getModifiers());
    }

    private static boolean isIsGetter(Method method) {
        String name = method.getName();
        return name.startsWith("is") && name.length() > 2 && method.getReturnType() != Void.TYPE && method.getParameterCount() == 0 && !Modifier.isStatic(method.getModifiers());
    }

    private static String removeCamelCasePrefix(String string, int prefixLength) {
        char firstChar = Character.toLowerCase(string.charAt(prefixLength));
        StringBuilder sb = new StringBuilder(string.length() - prefixLength);
        sb.append(firstChar).append(string, prefixLength + 1, string.length());
        return sb.toString();
    }

    private static Annotation[] combineAnnotations(AnnotatedElement element1, AnnotatedElement element2) {
        HashSet<Class<? extends Annotation>> typesSeen = new HashSet<Class<? extends Annotation>>();
        ArrayList<Annotation> result = new ArrayList<Annotation>();
        for (Annotation a : element1.getAnnotations()) {
            typesSeen.add(a.annotationType());
            result.add(a);
        }
        for (Annotation a : element2.getAnnotations()) {
            if (typesSeen.contains(a.annotationType())) continue;
            result.add(a);
        }
        return (Annotation[])result.toArray(Annotation[]::new);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.ClassProperty", ClassProperty.class, (String)"MCP", null);
        EMPTY_ANNOTATIONS = new Tool.Annotations[0];
    }
}

