/*
 * Decompiled with CFR 0.152.
 */
package graphql.execution.instrumentation.dataloader;

import graphql.Assert;
import graphql.ExecutionResult;
import graphql.Internal;
import graphql.execution.FieldValueInfo;
import graphql.execution.ResultPath;
import graphql.execution.instrumentation.ExecutionStrategyInstrumentationContext;
import graphql.execution.instrumentation.InstrumentationContext;
import graphql.execution.instrumentation.InstrumentationState;
import graphql.execution.instrumentation.dataloader.LevelMap;
import graphql.execution.instrumentation.parameters.InstrumentationExecutionStrategyParameters;
import graphql.execution.instrumentation.parameters.InstrumentationFieldFetchParameters;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;
import org.dataloader.DataLoaderRegistry;
import org.slf4j.Logger;

@Internal
public class FieldLevelTrackingApproach {
    private final Supplier<DataLoaderRegistry> dataLoaderRegistrySupplier;
    private final Logger log;

    public FieldLevelTrackingApproach(Logger log, Supplier<DataLoaderRegistry> dataLoaderRegistrySupplier) {
        this.dataLoaderRegistrySupplier = dataLoaderRegistrySupplier;
        this.log = log;
    }

    public InstrumentationState createState() {
        return new CallStack();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutionStrategyInstrumentationContext beginExecutionStrategy(InstrumentationExecutionStrategyParameters parameters, InstrumentationState rawState) {
        final CallStack callStack = (CallStack)rawState;
        ResultPath path = parameters.getExecutionStrategyParameters().getPath();
        int parentLevel = path.getLevel();
        final int curLevel = parentLevel + 1;
        int fieldCount = parameters.getExecutionStrategyParameters().getFields().size();
        CallStack callStack2 = callStack;
        synchronized (callStack2) {
            callStack.increaseExpectedFetchCount(curLevel, fieldCount);
            callStack.increaseHappenedStrategyCalls(curLevel);
        }
        return new ExecutionStrategyInstrumentationContext(){

            @Override
            public void onDispatched(CompletableFuture<ExecutionResult> result) {
            }

            @Override
            public void onCompleted(ExecutionResult result, Throwable t) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFieldValuesInfo(List<FieldValueInfo> fieldValueInfoList) {
                boolean dispatchNeeded;
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    dispatchNeeded = FieldLevelTrackingApproach.this.handleOnFieldValuesInfo(fieldValueInfoList, callStack, curLevel);
                }
                if (dispatchNeeded) {
                    FieldLevelTrackingApproach.this.dispatch();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFieldValuesException() {
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    callStack.increaseHappenedOnFieldValueCalls(curLevel);
                }
            }
        };
    }

    private boolean handleOnFieldValuesInfo(List<FieldValueInfo> fieldValueInfos, CallStack callStack, int curLevel) {
        callStack.increaseHappenedOnFieldValueCalls(curLevel);
        int expectedStrategyCalls = this.getCountForList(fieldValueInfos);
        callStack.increaseExpectedStrategyCalls(curLevel + 1, expectedStrategyCalls);
        return this.dispatchIfNeeded(callStack, curLevel + 1);
    }

    private int getCountForList(List<FieldValueInfo> fieldValueInfos) {
        int result = 0;
        for (FieldValueInfo fieldValueInfo : fieldValueInfos) {
            if (fieldValueInfo.getCompleteValueType() == FieldValueInfo.CompleteValueType.OBJECT) {
                ++result;
                continue;
            }
            if (fieldValueInfo.getCompleteValueType() != FieldValueInfo.CompleteValueType.LIST) continue;
            result += this.getCountForList(fieldValueInfo.getFieldValueInfos());
        }
        return result;
    }

    public InstrumentationContext<Object> beginFieldFetch(InstrumentationFieldFetchParameters parameters, InstrumentationState rawState) {
        final CallStack callStack = (CallStack)rawState;
        ResultPath path = parameters.getEnvironment().getExecutionStepInfo().getPath();
        final int level = path.getLevel();
        return new InstrumentationContext<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onDispatched(CompletableFuture<Object> result) {
                boolean dispatchNeeded;
                CallStack callStack2 = callStack;
                synchronized (callStack2) {
                    callStack.increaseFetchCount(level);
                    dispatchNeeded = FieldLevelTrackingApproach.this.dispatchIfNeeded(callStack, level);
                }
                if (dispatchNeeded) {
                    FieldLevelTrackingApproach.this.dispatch();
                }
            }

            @Override
            public void onCompleted(Object result, Throwable t) {
            }
        };
    }

    private boolean dispatchIfNeeded(CallStack callStack, int level) {
        if (this.levelReady(callStack, level)) {
            return callStack.dispatchIfNotDispatchedBefore(level);
        }
        return false;
    }

    private boolean levelReady(CallStack callStack, int level) {
        if (level == 1) {
            return callStack.allFetchesHappened(1);
        }
        return this.levelReady(callStack, level - 1) && callStack.allOnFieldCallsHappened(level - 1) && callStack.allStrategyCallsHappened(level) && callStack.allFetchesHappened(level);
    }

    void dispatch() {
        DataLoaderRegistry dataLoaderRegistry = this.getDataLoaderRegistry();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Dispatching data loaders ({})", dataLoaderRegistry.getKeys());
        }
        dataLoaderRegistry.dispatchAll();
    }

    private DataLoaderRegistry getDataLoaderRegistry() {
        return this.dataLoaderRegistrySupplier.get();
    }

    private static class CallStack
    implements InstrumentationState {
        private final LevelMap expectedFetchCountPerLevel = new LevelMap();
        private final LevelMap fetchCountPerLevel = new LevelMap();
        private final LevelMap expectedStrategyCallsPerLevel = new LevelMap();
        private final LevelMap happenedStrategyCallsPerLevel = new LevelMap();
        private final LevelMap happenedOnFieldValueCallsPerLevel = new LevelMap();
        private final Set<Integer> dispatchedLevels = new LinkedHashSet<Integer>();

        CallStack() {
            this.expectedStrategyCallsPerLevel.set(1, 1);
        }

        void increaseExpectedFetchCount(int level, int count) {
            this.expectedFetchCountPerLevel.increment(level, count);
        }

        void increaseFetchCount(int level) {
            this.fetchCountPerLevel.increment(level, 1);
        }

        void increaseExpectedStrategyCalls(int level, int count) {
            this.expectedStrategyCallsPerLevel.increment(level, count);
        }

        void increaseHappenedStrategyCalls(int level) {
            this.happenedStrategyCallsPerLevel.increment(level, 1);
        }

        void increaseHappenedOnFieldValueCalls(int level) {
            this.happenedOnFieldValueCallsPerLevel.increment(level, 1);
        }

        boolean allStrategyCallsHappened(int level) {
            return this.happenedStrategyCallsPerLevel.get(level) == this.expectedStrategyCallsPerLevel.get(level);
        }

        boolean allOnFieldCallsHappened(int level) {
            return this.happenedOnFieldValueCallsPerLevel.get(level) == this.expectedStrategyCallsPerLevel.get(level);
        }

        boolean allFetchesHappened(int level) {
            return this.fetchCountPerLevel.get(level) == this.expectedFetchCountPerLevel.get(level);
        }

        public String toString() {
            return "CallStack{expectedFetchCountPerLevel=" + this.expectedFetchCountPerLevel + ", fetchCountPerLevel=" + this.fetchCountPerLevel + ", expectedStrategyCallsPerLevel=" + this.expectedStrategyCallsPerLevel + ", happenedStrategyCallsPerLevel=" + this.happenedStrategyCallsPerLevel + ", happenedOnFieldValueCallsPerLevel=" + this.happenedOnFieldValueCallsPerLevel + ", dispatchedLevels" + this.dispatchedLevels + '}';
        }

        public boolean dispatchIfNotDispatchedBefore(int level) {
            if (this.dispatchedLevels.contains(level)) {
                Assert.assertShouldNeverHappen("level " + level + " already dispatched", new Object[0]);
                return false;
            }
            this.dispatchedLevels.add(level);
            return true;
        }

        public void clearAndMarkCurrentLevelAsReady(int level) {
            this.expectedFetchCountPerLevel.clear();
            this.fetchCountPerLevel.clear();
            this.expectedStrategyCallsPerLevel.clear();
            this.happenedStrategyCallsPerLevel.clear();
            this.happenedOnFieldValueCallsPerLevel.clear();
            this.dispatchedLevels.clear();
            this.expectedFetchCountPerLevel.increment(level, 1);
            this.expectedStrategyCallsPerLevel.increment(level, 1);
            this.happenedStrategyCallsPerLevel.increment(level, 1);
        }
    }
}

