/*
 * Decompiled with CFR 0.152.
 */
package io.opencensus.common;

import jakarta.annotation.Nullable;
import java.util.TreeMap;

public final class ServerStatsFieldEnums {
    private static final int TOTALSIZE = ServerStatsFieldEnums.computeTotalSize();

    private ServerStatsFieldEnums() {
    }

    private static int computeTotalSize() {
        int sum = 0;
        for (Size sizeValue : Size.values()) {
            sum += sizeValue.value();
            ++sum;
        }
        return sum;
    }

    public static int getTotalSize() {
        return TOTALSIZE;
    }

    public static enum Size {
        SERVER_STATS_LB_LATENCY_SIZE(8),
        SERVER_STATS_SERVICE_LATENCY_SIZE(8),
        SERVER_STATS_TRACE_OPTION_SIZE(1);

        private final int value;

        private Size(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }
    }

    public static enum Id {
        SERVER_STATS_LB_LATENCY_ID(0),
        SERVER_STATS_SERVICE_LATENCY_ID(1),
        SERVER_STATS_TRACE_OPTION_ID(2);

        private final int value;
        private static final TreeMap<Integer, Id> map;

        private Id(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        @Nullable
        public static Id valueOf(int value) {
            return map.get(value);
        }

        static {
            map = new TreeMap();
            for (Id id : Id.values()) {
                map.put(id.value, id);
            }
        }
    }
}

