/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.persistence;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ui.persistence.IPersistenceDebugger;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.security.PrivilegedAction;

public class FilePersistenceDebugger
implements IPersistenceDebugger {
    private static final TraceComponent tc = Tr.register(FilePersistenceDebugger.class);

    private void tryClose(Closeable c) {
        block3: {
            if (c != null) {
                try {
                    c.close();
                }
                catch (IOException e) {
                    if (!tc.isDebugEnabled()) break block3;
                    Tr.debug((TraceComponent)tc, (String)"IOException while trying to close Closeable. Ignoring but here's the details.", (Object[])new Object[]{c, e});
                }
            }
        }
    }

    @Override
    public String getFileContents(final File file) {
        return new PrivilegedAction<String>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            @FFDCIgnore(value={IOException.class})
            public String run() {
                StringBuilder sb = new StringBuilder();
                FileInputStream fis = null;
                InputStreamReader isr = null;
                BufferedReader br = null;
                try {
                    fis = new FileInputStream(file);
                    isr = new InputStreamReader((InputStream)fis, StandardCharsets.UTF_8);
                    br = new BufferedReader(isr);
                    String line = br.readLine();
                    while (line != null) {
                        sb.append(line);
                        sb.append("\n");
                        line = br.readLine();
                    }
                }
                catch (IOException e) {
                    try {
                        sb.append("Unable to load file contents: ");
                        sb.append(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        FilePersistenceDebugger.this.tryClose(br);
                        FilePersistenceDebugger.this.tryClose(isr);
                        FilePersistenceDebugger.this.tryClose(fis);
                        throw throwable;
                    }
                    FilePersistenceDebugger.this.tryClose(br);
                    FilePersistenceDebugger.this.tryClose(isr);
                    FilePersistenceDebugger.this.tryClose(fis);
                }
                FilePersistenceDebugger.this.tryClose(br);
                FilePersistenceDebugger.this.tryClose(isr);
                FilePersistenceDebugger.this.tryClose(fis);
                return sb.toString();
            }
        }.run();
    }
}

