/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.social.web;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.social.SocialLoginConfig;
import com.ibm.ws.security.social.internal.utils.RequestUtil;
import com.ibm.ws.security.social.internal.utils.SocialLoginRequest;
import java.io.IOException;
import java.util.regex.Matcher;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RequestFilter
implements Filter {
    private static TraceComponent tc = Tr.register(RequestFilter.class, (String)"SOCIAL", (String)"com.ibm.ws.security.social.resources.SocialMessages");
    public static final String REDIRECT = "/redirect/";
    public static final String WELLKNOWN_CONFIG = "/.well-known/configuration";
    public static final String LOGOUT = "/logout";
    public static final String BACKCHANNEL_LOGOUT = "/backchannel_logout/";
    public static final String UNKNOWN = "UNKNOWN";
    static final long serialVersionUID = -4452233247920787489L;

    public void destroy() {
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        SocialLoginRequest socialLoginRequest = null;
        String pathInfo = request.getPathInfo();
        socialLoginRequest = pathInfo.startsWith(REDIRECT) ? this.createSocialLoginRequestWithAssociatedConfig(request, response, pathInfo, REDIRECT) : (pathInfo.startsWith(WELLKNOWN_CONFIG) ? new SocialLoginRequest(WELLKNOWN_CONFIG, request, response) : (pathInfo.startsWith(LOGOUT) ? new SocialLoginRequest(LOGOUT, request, response) : (pathInfo.startsWith(BACKCHANNEL_LOGOUT) ? this.createSocialLoginRequestWithAssociatedConfig(request, response, pathInfo, BACKCHANNEL_LOGOUT) : new SocialLoginRequest(UNKNOWN, request, response))));
        request.setAttribute("SocialLoginRequest", (Object)socialLoginRequest);
        chain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    protected SocialLoginRequest createSocialLoginRequestWithAssociatedConfig(HttpServletRequest request, HttpServletResponse response, String pathInfo, String requestType) {
        String provider = pathInfo.substring(requestType.length());
        SocialLoginConfig socialLoginConfig = RequestUtil.getSocialLoginConfig(provider);
        if (socialLoginConfig != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("doFilter redirect providerId:" + socialLoginConfig.getUniqueId()), (Object[])new Object[0]);
            }
            return new SocialLoginRequest(socialLoginConfig, requestType, request, response);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Failed to find a social login configuration for ID [" + provider + "]"), (Object[])new Object[0]);
        }
        return new SocialLoginRequest(requestType, request, response);
    }

    protected String getProviderNameFromUrl(Matcher m) {
        String componentId = m.group(1);
        return componentId;
    }

    public void init(FilterConfig fConfig) throws ServletException {
    }
}

