/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.scripting;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import javax.script.ScriptContext;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.AbstractIdentifiableInitializableComponent;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.UnmodifiableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.scripting.AbstractScriptEvaluator;
import net.shibboleth.utilities.java.support.scripting.EvaluableScript;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptedRunnable
extends AbstractIdentifiableInitializableComponent
implements Runnable,
UnmodifiableComponent {
    @NonnullAfterInit
    private EvaluableScript script;
    @NonnullAfterInit
    private RunnableScriptEvaluator scriptEvaluator;
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ScriptedRunnable.class);
    @Nullable
    private Object customObject;

    @Override
    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (null == this.script) {
            throw new ComponentInitializationException("No script has been provided");
        }
        this.scriptEvaluator = new RunnableScriptEvaluator(this.script);
        this.scriptEvaluator.setCustomObject(this.customObject);
        StringBuilder builder = new StringBuilder("ScriptedRunnable '").append(this.getId()).append("':");
        this.scriptEvaluator.setLogPrefix(builder.toString());
    }

    @Nullable
    public Object getCustomObject() {
        return this.customObject;
    }

    public void setCustomObject(@Nullable Object object) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.customObject = object;
    }

    @NonnullAfterInit
    public EvaluableScript getScript() {
        return this.script;
    }

    public void setScript(@Nonnull EvaluableScript matcherScript) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException(this);
        ComponentSupport.ifDestroyedThrowDestroyedComponentException(this);
        this.script = Constraint.isNotNull(matcherScript, "Attribute value matching script cannot be null");
    }

    @Override
    public void run() {
        this.scriptEvaluator.execute();
    }

    private class RunnableScriptEvaluator
    extends AbstractScriptEvaluator {
        public RunnableScriptEvaluator(EvaluableScript theScript) {
            super(theScript);
        }

        @Override
        protected void prepareContext(@Nonnull ScriptContext scriptContext, Object ... input) {
        }

        public void execute() {
            ScriptedRunnable.this.log.debug("{}: running script", (Object)this.getLogPrefix());
            this.evaluate(null);
        }
    }
}

