/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.providers.locals;

import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.operators.MultiOperator;
import io.smallrye.mutiny.operators.multi.MultiOperatorProcessor;
import io.smallrye.mutiny.subscription.MultiSubscriber;
import io.smallrye.reactive.messaging.providers.helpers.VertxContext;
import io.smallrye.reactive.messaging.providers.locals.LocalContextMetadata;
import io.vertx.core.Context;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.microprofile.reactive.messaging.Message;

public class ContextOperator {
    public static <T extends Message<?>> Multi<T> apply(Multi<T> publisher) {
        return new ContextMulti<T>(publisher);
    }

    static class ContextMulti<T extends Message<?>>
    extends MultiOperator<T, T> {
        public ContextMulti(Multi<T> upstream) {
            super(upstream);
        }

        public void subscribe(MultiSubscriber<? super T> subscriber) {
            ContextProcessor<? super T> operator = new ContextProcessor<T>(subscriber);
            this.upstream().subscribe().withSubscriber(operator);
        }

        static class ContextProcessor<T extends Message<?>>
        extends MultiOperatorProcessor<T, T> {
            private volatile Context rootContext;
            private static final AtomicReferenceFieldUpdater<ContextProcessor, Context> ROOT_CONTEXT_UPDATER = AtomicReferenceFieldUpdater.newUpdater(ContextProcessor.class, Context.class, "rootContext");

            public ContextProcessor(MultiSubscriber<? super T> downstream) {
                super(downstream);
            }

            public void onFailure(Throwable throwable) {
                Context root = ROOT_CONTEXT_UPDATER.getAndSet(this, null);
                if (root == null) {
                    super.onFailure(throwable);
                } else {
                    root.runOnContext(ignored -> super.onFailure(throwable));
                }
            }

            public void onItem(T item) {
                Optional metadata = item.getMetadata().get(LocalContextMetadata.class);
                if (metadata.isPresent()) {
                    Context context = ((LocalContextMetadata)metadata.get()).context();
                    ROOT_CONTEXT_UPDATER.compareAndSet(this, null, VertxContext.getRootContext(context));
                    VertxContext.runOnContext(context, () -> super.onItem((Object)item));
                } else {
                    super.onItem(item);
                }
            }

            public void request(long numberOfItems) {
                Context root = ROOT_CONTEXT_UPDATER.get(this);
                if (root != null) {
                    root.runOnContext(x -> super.request(numberOfItems));
                } else {
                    super.request(numberOfItems);
                }
            }

            public void onCompletion() {
                Context root = ROOT_CONTEXT_UPDATER.getAndSet(this, null);
                if (root == null) {
                    super.onCompletion();
                } else {
                    root.runOnContext(ignored -> super.onCompletion());
                }
            }
        }
    }
}

