/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.structures.Cache;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.WebSSOConsumer;
import com.ibm.ws.security.saml.sso20.binding.BasicMessageContext;
import com.ibm.ws.security.saml.sso20.internal.utils.HttpRequestInfo;
import com.ibm.ws.security.saml.sso20.internal.utils.InitialRequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.RequestUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.SamlUtil;
import com.ibm.ws.security.saml.sso20.internal.utils.UnsolicitedResponseCache;
import com.ibm.ws.security.saml.sso20.internal.utils.UserData;
import com.ibm.wsspi.webcontainer.servlet.IExtendedRequest;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.SubjectConfirmation;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class UnsolicitedHandler {
    private static TraceComponent tc = Tr.register(UnsolicitedHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    HttpServletRequest request;
    HttpServletResponse response;
    SsoRequest samlRequest;
    Map<String, Object> parameters;
    SsoSamlService ssoService;
    InitialRequestUtil irUtil = new InitialRequestUtil();
    static final long serialVersionUID = -1325257556264314189L;

    public UnsolicitedHandler(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Map<String, Object> parameters) {
        this.request = request;
        this.response = response;
        this.samlRequest = samlRequest;
        this.parameters = parameters;
        this.ssoService = (SsoSamlService)parameters.get(Constants.KEY_SAML_SERVICE);
    }

    /*
     * WARNING - void declaration
     */
    public void handleRequest(String externalRelayState) throws SamlException {
        Assertion assertion;
        UnsolicitedResponseCache resCache;
        BasicMessageContext<?, ?> msgCtx;
        String rawSamlResponse;
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SAML WEBSSO - IDP init or SP Unsolicited flow (ACS) starting", (Object[])new Object[0]);
        }
        String relayState = RequestUtil.getCookieId((IExtendedRequest)this.request, this.response, "SAML20UnsolicitedState");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("RelayState from cookie is [" + relayState + "]"), (Object[])new Object[0]);
        }
        RequestUtil.removeCookie(this.request, this.response, "SAML20UnsolicitedState");
        if (relayState == null || relayState.isEmpty() || !relayState.startsWith("idp_initial_")) {
            if (!this.samlRequest.getSsoConfig().getUseRelayStateForTarget()) {
                relayState = this.samlRequest.getSsoConfig().getTargetPageUrl();
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("RelayState from SAMLResponse is [" + externalRelayState + "]"), (Object[])new Object[0]);
                }
                if ((relayState = externalRelayState) == null || relayState.isEmpty()) {
                    relayState = this.samlRequest.getSsoConfig().getTargetPageUrl();
                }
            }
        }
        if (relayState == null || relayState.isEmpty()) {
            throw new SamlException("SAML20_NO_PROTECTED_RESOURCE_ENDPOINT_ERR", null, new Object[0]);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Final target [" + relayState + "]"), (Object[])new Object[0]);
        }
        if ((rawSamlResponse = this.request.getParameter("SAMLResponse")) != null) {
            try {
                relayState = URLDecoder.decode(relayState, "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                void e;
                FFDCFilter.processException((Throwable)unsupportedEncodingException, (String)"com.ibm.ws.security.saml.sso20.acs.UnsolicitedHandler", (String)"119", (Object)this, (Object[])new Object[]{externalRelayState});
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Internal error process SAML Web SSO Version 2.0 request", (Object[])new Object[]{e});
                }
                throw new SamlException((Exception)e);
            }
            msgCtx = WebSSOConsumer.getInstance().handleSAMLResponse(this.request, this.response, this.ssoService, null, this.samlRequest);
            resCache = this.ssoService.getUnsolicitedResponseCache(this.samlRequest.getProviderName());
            assertion = msgCtx.getValidatedAssertion();
            if (resCache.isValid(assertion.getID())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("The SAML Assertion with ID " + assertion.getID() + " can not be processed twice."), (Object[])new Object[0]);
                }
                throw new SamlException("SAML20_RESPONSE_REPLAY", null, new Object[]{assertion.getID()});
            }
        } else {
            throw new SamlException("Cannot process the request because SAML Response from the IdP is missing", null, new Object[0]);
        }
        long exp = ((SubjectConfirmation)assertion.getSubject().getSubjectConfirmations().get(0)).getSubjectConfirmationData().getNotOnOrAfter().toEpochMilli();
        resCache.put(assertion.getID(), exp);
        Cache cache = this.ssoService.getAcsCookieCache(this.samlRequest.getProviderName());
        HttpRequestInfo requestInfo = this.getUnsolicitedRequestInfo(msgCtx, relayState, cache);
        requestInfo.setWithFragmentUrl(this.request, this.response);
        this.redirectToRelayState(msgCtx, this.samlRequest.getProviderName(), cache, requestInfo);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"SAML WEBSSO - IDP init or SP Unsolicited flow (ACS) ends", (Object[])new Object[0]);
        }
    }

    HttpRequestInfo getUnsolicitedRequestInfo(BasicMessageContext<?, ?> msgCtx, String relayState, Cache cache) throws SamlException {
        HttpRequestInfo requestInfo = this.getCachedRequestInfo(relayState, cache);
        if (requestInfo == null) {
            requestInfo = new HttpRequestInfo(relayState, "");
        }
        return requestInfo;
    }

    protected void redirectToRelayState(BasicMessageContext<?, ?> msgCtx, String providerName, Cache cache, HttpRequestInfo requestInfo) throws SamlException {
        String cacheId = SamlUtil.generateRandom();
        UserData data = msgCtx.getUserDataIfReady();
        cache.put(cacheId, (Object)data);
        requestInfo.redirectCachedHttpRequest(this.request, this.response, "WASSamlACS_" + SamlUtil.hash(providerName), cacheId);
    }

    protected HttpRequestInfo getCachedRequestInfo(String relayState, Cache cache) throws SamlException {
        if (relayState == null) {
            return null;
        }
        HttpRequestInfo requestInfo = null;
        if (relayState.startsWith("idp_initial_")) {
            String cacheKey = relayState.substring("idp_initial_".length());
            requestInfo = (HttpRequestInfo)cache.get(cacheKey);
            if (requestInfo != null) {
                cache.remove((Object)cacheKey);
                this.irUtil.removeCookie(relayState, this.request, this.response);
            } else {
                requestInfo = this.irUtil.recreateHttpRequestInfo(relayState, this.request, this.response, this.ssoService);
            }
        }
        return requestInfo;
    }
}

