/*
 * Decompiled with CFR 0.152.
 */
package net.jodah.failsafe.internal;

import net.jodah.failsafe.CircuitBreaker;
import net.jodah.failsafe.internal.CircuitBreakerStats;
import net.jodah.failsafe.internal.CircuitState;
import net.jodah.failsafe.internal.util.CircularBitSet;
import net.jodah.failsafe.util.Ratio;

public class ClosedState
extends CircuitState {
    private final CircuitBreaker circuit;
    private CircularBitSet bitSet;

    public ClosedState(CircuitBreaker circuit) {
        this.circuit = circuit;
        this.setFailureThreshold(circuit.getFailureThreshold() != null ? circuit.getFailureThreshold() : ONE_OF_ONE);
    }

    @Override
    public boolean allowsExecution(CircuitBreakerStats stats) {
        return true;
    }

    @Override
    public CircuitBreaker.State getState() {
        return CircuitBreaker.State.CLOSED;
    }

    @Override
    public synchronized void recordFailure() {
        this.bitSet.setNext(false);
        this.checkThreshold();
    }

    @Override
    public synchronized void recordSuccess() {
        this.bitSet.setNext(true);
        this.checkThreshold();
    }

    @Override
    public void setFailureThreshold(Ratio threshold) {
        this.bitSet = new CircularBitSet(threshold.denominator, this.bitSet);
    }

    synchronized void checkThreshold() {
        Ratio failureRatio = this.circuit.getFailureThreshold();
        if (failureRatio != null && this.bitSet.occupiedBits() >= failureRatio.denominator && this.bitSet.negativeRatio() >= failureRatio.ratio) {
            this.circuit.open();
        }
        if (failureRatio == null && this.bitSet.negativeRatio() == 1.0) {
            this.circuit.open();
        }
    }
}

