/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.openapi31;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.metadata.MetaDataEvent;
import com.ibm.ws.container.service.metadata.MetaDataException;
import com.ibm.ws.container.service.metadata.ModuleMetaDataListener;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.openapi31.OpenAPIUtils;
import com.ibm.ws.openapi31.OpenAPIWebProvider;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ModuleMetaData;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.http.VirtualHost;
import com.ibm.wsspi.http.VirtualHostListener;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.webcontainer.metadata.WebModuleMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={ModuleMetaDataListener.class, VirtualHostListener.class}, immediate=true, property={"service.vendor=IBM"})
public class OpenAPIModuleListener
implements ModuleMetaDataListener,
VirtualHostListener {
    private static final TraceComponent tc = Tr.register(OpenAPIModuleListener.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
    private ComponentContext context;
    private static final String KEY_EXECUTOR_SERVICE_REF = "executorService";
    private final AtomicServiceReference<ScheduledExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    private final ConcurrentHashMap<String, OpenAPIWebProvider> webAPIProviders = new ConcurrentHashMap();
    private static final List<String> contextRootsToIgnore = new ArrayList<String>();
    private ScheduledFuture<?> scheduledWabProcessor;
    static final long serialVersionUID = -4917641603889311018L;

    @Activate
    protected void activate(ComponentContext context, Map<String, Object> properties) {
        this.context = context;
        this.executorServiceRef.activate(context);
        this.scheduledWabProcessor = this.getExecutorService().scheduleWithFixedDelay(new Runnable(){
            static final long serialVersionUID = 8345656199996747727L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    OpenAPIModuleListener.this.processWABs();
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    void e;
                    FFDCFilter.processException((Throwable)invalidSyntaxException, (String)"com.ibm.ws.openapi31.OpenAPIModuleListener$1", (String)"97", (Object)this, (Object[])new Object[0]);
                    if (OpenAPIUtils.isEventEnabled(tc)) {
                        Tr.event((TraceComponent)tc, (String)("Exception while processing WABs: " + e.getMessage()), (Object[])new Object[0]);
                    }
                    throw new RuntimeException((Throwable)e);
                }
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.OpenAPIModuleListener$1", 1.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
            }
        }, 2L, 1L, TimeUnit.SECONDS);
        this.getExecutorService().schedule(new Runnable(){
            static final long serialVersionUID = -940295303361111918L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            public void run() {
                if (OpenAPIUtils.isEventEnabled(tc)) {
                    Tr.event((TraceComponent)tc, (String)"Running fail-safe routine to cleanup scheduler", (Object[])new Object[0]);
                }
                OpenAPIModuleListener.this.cancelScheduler();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.openapi31.OpenAPIModuleListener$2", 2.class, (String)"OpenAPI", (String)"com.ibm.ws.openapi31.resources.OpenAPIMessages");
            }
        }, 60L, TimeUnit.SECONDS);
    }

    @Deactivate
    protected void deactivate(ComponentContext context, int reason) {
        this.cancelScheduler();
        this.executorServiceRef.deactivate(context);
        this.context = null;
    }

    @Reference(name="executorService", service=ScheduledExecutorService.class)
    protected void setExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.setReference(ref);
    }

    protected void unsetExecutorService(ServiceReference<ScheduledExecutorService> ref) {
        this.executorServiceRef.unsetReference(ref);
    }

    private ScheduledExecutorService getExecutorService() {
        ScheduledExecutorService service = (ScheduledExecutorService)this.executorServiceRef.getService();
        if (service == null) {
            throw new IllegalStateException(OpenAPIUtils.getOsgiServiceErrorMessage(this.getClass(), "ScheduledExecutorService"));
        }
        return service;
    }

    public void moduleMetaDataCreated(MetaDataEvent<ModuleMetaData> event) throws MetaDataException {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String contextRoot = ((WebModuleMetaData)event.getMetaData()).getConfiguration().getContextRoot();
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("WebModule metadata created for module " + ((ModuleMetaData)event.getMetaData()).getJ2EEName() + " | context root " + contextRoot + " | in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication()), (Object[])new Object[0]);
            }
            this.processModule(contextRoot, event.getContainer());
        }
    }

    private boolean processModule(String contextRoot, Container container) {
        for (String ignore : contextRootsToIgnore) {
            if (!contextRoot.equals(ignore)) continue;
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Matched ignored root: " + ignore), (Object[])new Object[0]);
            }
            return true;
        }
        OpenAPIWebProvider webProvider = null;
        try {
            webProvider = (OpenAPIWebProvider)container.adapt(OpenAPIWebProvider.class);
        }
        catch (UnableToAdaptException ignore) {
            FFDCFilter.processException((Throwable)ignore, (String)"com.ibm.ws.openapi31.OpenAPIModuleListener", (String)"187", (Object)this, (Object[])new Object[]{contextRoot, container});
            Tr.event((TraceComponent)tc, (String)("Failed to adapt module: " + contextRoot), (Object[])new Object[0]);
            return true;
        }
        if (webProvider == null) {
            return true;
        }
        OpenAPIWebProvider oldWebProvider = this.webAPIProviders.putIfAbsent(contextRoot, webProvider);
        if (oldWebProvider != null) {
            webProvider = oldWebProvider;
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)("Added into the map {" + contextRoot + "," + webProvider + "}"), (Object[])new Object[0]);
        }
        return true;
    }

    public void moduleMetaDataDestroyed(MetaDataEvent<ModuleMetaData> event) {
        if (event.getMetaData() instanceof WebModuleMetaData) {
            String contextRoot = ((WebModuleMetaData)event.getMetaData()).getConfiguration().getContextRoot();
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("WebModule metadata destroyed for module " + ((ModuleMetaData)event.getMetaData()).getJ2EEName() + " | context root " + contextRoot + " | in app " + ((ModuleMetaData)event.getMetaData()).getJ2EEName().getApplication()), (Object[])new Object[0]);
            }
            OpenAPIWebProvider webProvider = this.webAPIProviders.remove(contextRoot);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("Removed from map {" + contextRoot + "," + webProvider + "}"), (Object[])new Object[0]);
            }
            if (webProvider != null) {
                webProvider.setEnabled(false);
            }
        }
    }

    private OpenAPIWebProvider getWebProviderFromRoot(String contextRoot) {
        return this.webAPIProviders.get(contextRoot);
    }

    public void contextRootAdded(String contextRoot, VirtualHost virtualHost) {
        OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(contextRoot = OpenAPIUtils.normalizeContextRoot(contextRoot));
        if (webProvider != null) {
            String moduleURL = virtualHost.getUrlString(contextRoot, false);
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)("About to update moduleURL: " + moduleURL), (Object[])new Object[0]);
            }
            webProvider.setModuleURL(moduleURL.endsWith("/") ? moduleURL.substring(0, moduleURL.length() - 1) : moduleURL);
            webProvider.setModuleURL(contextRoot);
            if (!"default_host".equals(virtualHost.getName())) {
                ArrayList<String> hosts = new ArrayList<String>();
                hosts.add(moduleURL.substring(0, moduleURL.lastIndexOf(contextRoot)));
                String securedModuleURL = virtualHost.getUrlString(contextRoot, true);
                String securedHost = securedModuleURL.substring(0, securedModuleURL.lastIndexOf(contextRoot));
                if (!hosts.contains(securedHost)) {
                    hosts.add(securedHost);
                }
                webProvider.setNonDefaultHosts(hosts);
            }
            if (OpenAPIUtils.isEventEnabled(tc)) {
                Tr.event((TraceComponent)tc, (String)"No existing configuration found, just enable the web provider obj.", (Object[])new Object[0]);
            }
            webProvider.setEnabled(true);
        }
    }

    public void contextRootRemoved(String contextRoot, VirtualHost virtualHost) {
    }

    protected void processWABs() throws InvalidSyntaxException {
        if (this.context == null) {
            return;
        }
        ServiceReference[] refs = this.context.getBundleContext().getServiceReferences(Bundle.class.getName(), "(installed.wab.contextRoot=*)");
        if (refs != null) {
            for (ServiceReference ref : refs) {
                String contextRoot = (String)ref.getProperty("installed.wab.contextRoot");
                Container container = (Container)ref.getProperty("installed.wab.container");
                OpenAPIWebProvider webProvider = this.getWebProviderFromRoot(contextRoot);
                if (webProvider != null) continue;
                boolean processedModule = this.processModule(contextRoot, container);
                if (!processedModule) {
                    return;
                }
                webProvider = this.getWebProviderFromRoot(contextRoot);
                if (webProvider == null) continue;
                webProvider.setModuleURL(contextRoot);
                webProvider.setEnabled(true);
            }
        }
        if (OpenAPIUtils.isEventEnabled(tc)) {
            Tr.event((TraceComponent)tc, (String)"Finished processing WABs, so cleaning up scheduler", (Object[])new Object[0]);
        }
        this.cancelScheduler();
    }

    private void cancelScheduler() {
        if (!this.scheduledWabProcessor.isCancelled()) {
            this.scheduledWabProcessor.cancel(true);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        contextRootsToIgnore.add("/ibm/api");
        contextRootsToIgnore.add("/ibm/api/explorer");
        contextRootsToIgnore.add("/IBMJMXConnectorREST");
    }
}

