/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.event;

import graphql.GraphQL;
import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.cdi.event.AfterDataFetch;
import io.smallrye.graphql.cdi.event.AfterExecute;
import io.smallrye.graphql.cdi.event.BeforeDataFetch;
import io.smallrye.graphql.cdi.event.BeforeExecute;
import io.smallrye.graphql.cdi.event.ErrorDataFetch;
import io.smallrye.graphql.cdi.event.ErrorExecute;
import io.smallrye.graphql.cdi.event.ErrorInfo;
import io.smallrye.graphql.execution.event.InvokeInfo;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.spi.EventingService;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.CDI;
import java.lang.annotation.Annotation;

public class EventsService
implements EventingService {
    @Override
    public GraphQLSchema.Builder beforeSchemaBuild(GraphQLSchema.Builder builder) {
        this.fire(builder, new Annotation[0]);
        return builder;
    }

    @Override
    public Operation createOperation(Operation operation) {
        this.fire(operation, new Annotation[0]);
        return operation;
    }

    @Override
    public GraphQL.Builder beforeGraphQLBuild(GraphQL.Builder builder) {
        this.fire(builder, new Annotation[0]);
        return builder;
    }

    @Override
    public void beforeExecute(Context context) {
        this.fire(context, BeforeExecute.LITERAL);
    }

    @Override
    public void afterExecute(Context context) {
        this.fire(context, AfterExecute.LITERAL);
    }

    @Override
    public void beforeDataFetch(Context context) {
        this.fire(context, BeforeDataFetch.LITERAL);
    }

    @Override
    public void beforeInvoke(InvokeInfo invokeInfo) throws Exception {
        this.fire(invokeInfo, new Annotation[0]);
    }

    @Override
    public void afterDataFetch(Context context) {
        this.fire(context, AfterDataFetch.LITERAL);
    }

    @Override
    public void errorExecute(String executionId, Throwable t) {
        this.fire(new ErrorInfo(executionId, t), ErrorExecute.LITERAL);
    }

    @Override
    public void errorDataFetch(String executionId, Throwable t) {
        this.fire(new ErrorInfo(executionId, t), ErrorDataFetch.LITERAL);
    }

    @Override
    public String getConfigKey() {
        return "smallrye.graphql.events.enabled";
    }

    private void fire(Object o, Annotation ... annotation) {
        try {
            BeanManager beanManager;
            CDI current = CDI.current();
            if (current != null && (beanManager = current.getBeanManager()) != null) {
                beanManager.fireEvent(o, annotation);
            }
        }
        catch (IllegalStateException ise) {
            ise.printStackTrace();
        }
    }
}

