/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.server.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HashUtils {
    private static final TraceComponent tc = Tr.register(HashUtils.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.server.internal.resources.OidcServerMessages");
    private static String DEFAULT_ALGORITHM = "SHA-256";
    private static Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    static final long serialVersionUID = 4246529675551735176L;

    public static String digest(String input) {
        return HashUtils.digest(input, DEFAULT_ALGORITHM);
    }

    protected static String digest(String input, String algorithm) {
        return HashUtils.digest(input, algorithm, DEFAULT_CHARSET);
    }

    /*
     * WARNING - void declaration
     */
    protected static String digest(String input, String algorithm, Charset charset) {
        String output = null;
        if (input != null && input.length() > 0) {
            try {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(input.getBytes(charset));
                output = Base64Coder.toString((byte[])Base64Coder.base64Encode((byte[])md.digest()));
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                void nsae;
                FFDCFilter.processException((Throwable)noSuchAlgorithmException, (String)"com.ibm.ws.security.openidconnect.server.internal.HashUtils", (String)"61", null, (Object[])new Object[]{input, algorithm, charset});
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception instanciating MessageDigest. The algorithm is " + algorithm + nsae), (Object[])new Object[0]);
                }
                throw new RuntimeException("Exception instanciating MessageDigest : " + nsae);
            }
        }
        return output;
    }
}

