/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.wsat.common.impl;

import com.ibm.tx.remote.Vote;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.jaxws.wsat.Constants;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.wsat.common.impl.DebugUtils;
import com.ibm.ws.wsat.common.impl.WSATCoordinator;
import com.ibm.ws.wsat.common.impl.WSATParticipant;
import com.ibm.ws.wsat.service.WSATContext;
import com.ibm.ws.wsat.service.WSATException;
import com.ibm.ws.wsat.service.impl.ProtocolImpl;
import com.ibm.ws.wsat.tm.impl.TranManagerImpl;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.JAXBElement;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.addressing.ReferenceParametersType;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WSATTransaction {
    private static final TraceComponent TC = Tr.register(WSATTransaction.class, (String)"wsat", (String)"com.ibm.ws.wsat.resources.WSAT");
    private static final TranManagerImpl tranService = TranManagerImpl.getInstance();
    private final String globalId;
    private WSATCoordinator registration;
    private WSATCoordinator coordinator;
    private final Boolean coordinatorLock = false;
    private final boolean recoveryTran;
    private final long expiryTime;
    private final Map<String, WSATParticipant> participants = new ConcurrentHashMap<String, WSATParticipant>();
    static final long serialVersionUID = -797954037133491971L;

    public static void putTran(WSATTransaction tran) {
        tranService.getRemoteTranMgr().putResource(tran.getGlobalId(), (Object)tran);
    }

    public static WSATTransaction getTran(String globalId) {
        return (WSATTransaction)tranService.getRemoteTranMgr().getResource(globalId);
    }

    public boolean equals(Object o) {
        return o instanceof WSATTransaction && this.globalId.equals(((WSATTransaction)o).getGlobalId());
    }

    public static WSATTransaction getCoordTran(String globalId) {
        return WSATTransaction.getTran(globalId);
    }

    public WSATTransaction(String id, long timeout) {
        this(id, timeout, false);
    }

    public WSATTransaction(String id, long timeout, boolean recovery) {
        this.globalId = id;
        this.expiryTime = timeout;
        this.recoveryTran = recovery;
    }

    @Trivial
    public String getGlobalId() {
        return this.globalId;
    }

    @Trivial
    protected boolean isRecovery() {
        return this.recoveryTran;
    }

    @Trivial
    public long getTimeout() {
        return this.expiryTime;
    }

    public WSATCoordinator setRegistration(EndpointReferenceType epr) {
        this.registration = new WSATCoordinator(this.globalId, epr);
        return this.registration;
    }

    public WSATCoordinator getRegistration() {
        return this.registration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSATCoordinator setCoordinator(EndpointReferenceType epr) {
        Boolean bl = this.coordinatorLock;
        synchronized (bl) {
            this.coordinator = new WSATCoordinator(this.globalId, epr);
            return this.coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSATCoordinator setCoordinator(WSATCoordinator coord) {
        Boolean bl = this.coordinatorLock;
        synchronized (bl) {
            this.coordinator = coord;
            return this.coordinator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WSATCoordinator getCoordinator() {
        Boolean bl = this.coordinatorLock;
        synchronized (bl) {
            return this.coordinator;
        }
    }

    public WSATContext getContext() {
        WSATContext ctx = null;
        if (!this.isRecovery()) {
            ctx = new WSATContext(this.getGlobalId(), this.getRegistration(), this.getTimeout());
        } else if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Transaction is in recovery mode, returning null CoordinationContext", (Object[])new Object[0]);
        }
        return ctx;
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.globalId;
    }

    public synchronized void rollback() throws WSATException {
        tranService.rollbackTransaction(this.globalId);
    }

    public synchronized Vote prepare() throws WSATException {
        return tranService.prepareTransaction(this.globalId);
    }

    public synchronized void commit() throws WSATException {
        tranService.commitTransaction(this.globalId);
    }

    public EndpointReferenceType getCoordinatorEPR(EndpointReferenceType bareEpr, String partId) {
        EndpointReferenceType epr = EndpointReferenceUtils.duplicate((EndpointReferenceType)bareEpr);
        ReferenceParametersType refs = new ReferenceParametersType();
        for (Object ref : bareEpr.getReferenceParameters().getAny()) {
            if (TC.isDebugEnabled()) {
                Tr.debug((TraceComponent)TC, (String)"Adding this reference parameter: {0}, {1}", (Object[])new Object[]{ref.getClass().getCanonicalName(), ref});
                if (ref instanceof Node) {
                    Tr.debug((TraceComponent)TC, (String)"Local name: {0}", (Object[])new Object[]{((Node)ref).getLocalName()});
                    if ("ParticipantID".equals(((Node)ref).getLocalName())) {
                        Tr.debug((TraceComponent)TC, (String)"Skipping", (Object[])new Object[0]);
                        continue;
                    }
                }
            }
            refs.getAny().add(ref);
        }
        JAXBElement part = new JAXBElement(Constants.WS_WSAT_PART_REF, String.class, (Object)partId);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Now adding this additional reference parameter: {0}", (Object[])new Object[]{part});
        }
        refs.getAny().add(part);
        epr.setReferenceParameters(refs);
        return epr;
    }

    public WSATParticipant addParticipant(EndpointReferenceType epr) throws WSATException {
        String partId = UUID.randomUUID().toString();
        WSATParticipant participant = new WSATParticipant(this.getGlobalId(), partId, epr);
        this.participants.put(partId, participant);
        EndpointReferenceType bareCoordEpr = ProtocolImpl.getInstance().getCoordinatorEndpoint(this.getGlobalId());
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Bare coordinator EPR:\n{0}", (Object[])new Object[]{DebugUtils.printEPR(bareCoordEpr)});
        }
        EndpointReferenceType coordEpr = this.getCoordinatorEPR(bareCoordEpr, partId);
        participant.setCoordinator(new WSATCoordinator(this.getGlobalId(), coordEpr));
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Added new participant: {0}", (Object[])new Object[]{participant});
        }
        return participant;
    }

    public WSATParticipant addParticipant(WSATParticipant participant) {
        EndpointReferenceType coordEpr = this.getCoordinator().getEndpointReference(participant.getId());
        participant.setCoordinator(new WSATCoordinator(this.getGlobalId(), coordEpr));
        this.participants.put(participant.getId(), participant);
        if (TC.isDebugEnabled()) {
            Tr.debug((TraceComponent)TC, (String)"Restored recovered participant: {0}", (Object[])new Object[]{participant});
        }
        return participant;
    }

    public void removeParticipant(String partId) {
        this.participants.remove(partId);
    }

    public WSATParticipant getParticipant(String partId) {
        return this.participants.get(partId);
    }
}

