/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.signature.support.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignaturePrevalidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChainingSignaturePrevalidator
implements SignaturePrevalidator {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ChainingSignaturePrevalidator.class);
    @Nonnull
    @NonnullElements
    private List<SignaturePrevalidator> validators;

    public ChainingSignaturePrevalidator(@Nonnull @ParameterName(name="validatorChain") @NonnullElements List<SignaturePrevalidator> validatorChain) {
        this.validators = Collections.unmodifiableList(new ArrayList((Collection)Constraint.isNotNull(validatorChain, (String)"SignaturePrevalidator list cannot be null")));
    }

    @Override
    public void validate(@Nonnull Signature signature) throws SignatureException {
        for (SignaturePrevalidator validator : this.validators) {
            this.log.debug("Validating signature using prevalidator: {}", (Object)validator.getClass().getName());
            validator.validate(signature);
        }
    }
}

