/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullAfterInit;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.ComponentSupport;
import net.shibboleth.utilities.java.support.component.InitializableComponent;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.navigate.SAMLMessageContextIssuerFunction;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.Request;
import org.opensaml.saml.saml1.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolveArtifacts
extends AbstractProfileAction {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(ResolveArtifacts.class);
    @Nonnull
    private Function<ProfileRequestContext, Request> requestLookupStrategy = new MessageLookup(Request.class).compose((Function)((Object)new InboundMessageContextLookup()));
    @Nonnull
    private Function<ProfileRequestContext, Response> responseLookupStrategy = new MessageLookup(Response.class).compose((Function)((Object)new OutboundMessageContextLookup()));
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, String> requesterLookupStrategy = new SAMLMessageContextIssuerFunction().compose(new InboundMessageContextLookup());
    @NonnullAfterInit
    private SAMLArtifactMap artifactMap;
    @Nullable
    private Request request;
    @Nullable
    private Response response;
    @Nullable
    private String issuerId;
    @Nullable
    private String requesterId;

    public synchronized void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, Request> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
    }

    public synchronized void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, Response> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public synchronized void setIssuerLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.issuerLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Issuer lookup strategy cannot be null");
    }

    public synchronized void setRequesterLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.requesterLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Requester lookup strategy cannot be null");
    }

    public synchronized void setArtifactMap(@Nonnull SAMLArtifactMap map) {
        ComponentSupport.ifInitializedThrowUnmodifiabledComponentException((InitializableComponent)this);
        this.artifactMap = (SAMLArtifactMap)Constraint.isNotNull((Object)map, (String)"SAMLArtifactMap cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.artifactMap == null) {
            throw new ComponentInitializationException("SAMLArtifactMap cannot be null");
        }
        if (this.issuerLookupStrategy == null) {
            throw new ComponentInitializationException("Issuer lookup strategy cannot be null");
        }
    }

    @Override
    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.request = this.requestLookupStrategy.apply(profileRequestContext);
        if (this.request == null) {
            this.log.debug("{} No request located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        if (this.request.getAssertionArtifacts().isEmpty()) {
            this.log.debug("{} No AssertionArtifact elements found in request, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No response located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        if (this.issuerId == null) {
            this.log.debug("{} No issuer identity located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidProfileContext");
            return false;
        }
        this.requesterId = this.requesterLookupStrategy.apply(profileRequestContext);
        if (this.requesterId == null) {
            this.log.debug("{} No requester identity located", (Object)this.getLogPrefix());
            ActionSupport.buildEvent(profileRequestContext, "InvalidMessageContext");
            return false;
        }
        return super.doPreExecute(profileRequestContext);
    }

    @Override
    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        boolean success = true;
        try {
            for (AssertionArtifact artifact : this.request.getAssertionArtifacts()) {
                SAMLArtifactMap.SAMLArtifactMapEntry entry = this.artifactMap.get(artifact.getValue());
                if (entry == null) {
                    this.log.warn("{} Unresolvable AssertionArtifact '{}' from relying party '{}'", new Object[]{this.getLogPrefix(), artifact.getValue(), this.requesterId});
                    success = false;
                    break;
                }
                this.artifactMap.remove(artifact.getValue());
                if (!entry.getIssuerId().equals(this.issuerId)) {
                    this.log.warn("{} Artifact issuer mismatch, issued by '{}' but IdP has entityID of '{}'", new Object[]{this.getLogPrefix(), entry.getIssuerId(), this.issuerId});
                    success = false;
                    break;
                }
                if (!entry.getRelyingPartyId().equals(this.requesterId)) {
                    this.log.warn("{} Artifact relying party mismatch, issued to '{}' but requested by '{}'", new Object[]{this.getLogPrefix(), entry.getRelyingPartyId(), this.requesterId});
                    success = false;
                    break;
                }
                if (!(entry.getSamlMessage() instanceof Assertion)) {
                    this.log.warn("{} Artifact '{}' resolved to a non-Assertion object", (Object)this.getLogPrefix(), (Object)artifact.getValue());
                    success = false;
                    break;
                }
                this.response.getAssertions().add((Assertion)entry.getSamlMessage());
            }
        }
        catch (IOException e) {
            this.log.error("{} Error resolving artifact", (Object)this.getLogPrefix(), (Object)e);
            success = false;
        }
        if (!success) {
            this.response.getAssertions().clear();
            for (AssertionArtifact artifact : this.request.getAssertionArtifacts()) {
                try {
                    this.artifactMap.remove(artifact.getValue());
                }
                catch (IOException e) {
                    this.log.error("{} Error removing mapping for artifact '{}'", (Object)this.getLogPrefix(), (Object)artifact.getValue());
                }
            }
            ActionSupport.buildEvent(profileRequestContext, "UnableToResolveArtifact");
        }
    }
}

