/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.client.security.authorization.oauth;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Map;
import java.util.Set;
import javax.security.auth.Subject;

public class GrpcOAuthPropagationHelper {
    private static final TraceComponent tc = Tr.register(GrpcOAuthPropagationHelper.class, (String)"GRPC", (String)"io.openliberty.grpc.internal.client.resources.grpcclientmessages");
    public static final String ISSUED_JWT_TOKEN = "issuedJwt";

    public static String getAccessTokenType() {
        return GrpcOAuthPropagationHelper.getSubjectAttributeString("token_type", true);
    }

    public static String getAccessToken() {
        return GrpcOAuthPropagationHelper.getSubjectAttributeString("access_token", true);
    }

    public static String getJwtToken() {
        String jwt = GrpcOAuthPropagationHelper.getIssuedJwtToken();
        if (jwt == null && !GrpcOAuthPropagationHelper.isJwt(jwt = GrpcOAuthPropagationHelper.getAccessToken())) {
            jwt = null;
        }
        return jwt;
    }

    private static boolean isJwt(String jwt) {
        return jwt != null && jwt.indexOf(".") >= 0;
    }

    public static String getIssuedJwtToken() {
        return GrpcOAuthPropagationHelper.getSubjectAttributeString(ISSUED_JWT_TOKEN, true);
    }

    public static String getScopes() {
        return GrpcOAuthPropagationHelper.getSubjectAttributeString("scope", true);
    }

    static Subject getRunAsSubject() {
        try {
            return WSSubject.getRunAsSubject();
        }
        catch (WSSecurityException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting runAsSubject:", (Object[])new Object[]{e.getCause()});
            }
            return null;
        }
    }

    static String getSubjectAttributeString(String attribKey, boolean bindWithAccessToken) {
        block3: {
            try {
                Subject runAsSubject = GrpcOAuthPropagationHelper.getRunAsSubject();
                if (runAsSubject != null) {
                    return GrpcOAuthPropagationHelper.getSubjectAttributeObject(runAsSubject, attribKey, bindWithAccessToken);
                }
            }
            catch (Exception e) {
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block3;
                Tr.debug((TraceComponent)tc, (String)"Exception caught", (Object[])new Object[]{e});
            }
        }
        return null;
    }

    @FFDCIgnore(value={PrivilegedActionException.class})
    static String getSubjectAttributeObject(Subject subject, String attribKey, boolean bindWithAccessToken) {
        try {
            Set<Object> publicCredentials = subject.getPublicCredentials();
            String result = GrpcOAuthPropagationHelper.getCredentialAttribute(publicCredentials, attribKey, bindWithAccessToken, "publicCredentials");
            if (result == null || result.isEmpty()) {
                Set<Object> privateCredentials = subject.getPrivateCredentials();
                result = GrpcOAuthPropagationHelper.getCredentialAttribute(privateCredentials, attribKey, bindWithAccessToken, "privateCredentials");
            }
            return result;
        }
        catch (PrivilegedActionException e) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Did not find a value for the attribute (" + attribKey + ")"), (Object[])new Object[0]);
            }
            return null;
        }
    }

    static String getCredentialAttribute(final Set<Object> credentials, final String attribKey, final boolean bindWithAccessToken, final String msg) throws PrivilegedActionException {
        Object obj = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

            @Override
            public Object run() throws Exception {
                int iCnt = 0;
                for (Object credentialObj : credentials) {
                    Object value;
                    Object accessToken;
                    ++iCnt;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)(msg + "(" + iCnt + ") class:" + credentialObj.getClass().getName()), (Object[])new Object[0]);
                    }
                    if (!(credentialObj instanceof Map) || bindWithAccessToken && (accessToken = ((Map)credentialObj).get("access_token")) == null || (value = ((Map)credentialObj).get(attribKey)) == null) continue;
                    return value;
                }
                return null;
            }
        });
        if (obj != null) {
            return obj.toString();
        }
        return null;
    }
}

