/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics30.setup.config;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics30.setup.config.PropertyArrayConfiguration;
import java.time.Duration;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class TimerBucketConfiguration
extends PropertyArrayConfiguration<Duration> {
    private static final TraceComponent tc = Tr.register(TimerBucketConfiguration.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    static final long serialVersionUID = -4976305329759764434L;

    public TimerBucketConfiguration(String metricName, Duration[] values) {
        super(metricName, values);
    }

    public static Collection<TimerBucketConfiguration> parse(String input) {
        String[] metricValuePairs;
        ArrayDeque<TimerBucketConfiguration> metricSLOConfiguration = new ArrayDeque<TimerBucketConfiguration>();
        if (input == null || input.length() == 0) {
            return null;
        }
        for (String kvString : metricValuePairs = input.split(";")) {
            String[] keyValueSplit = kvString.split("=");
            String metricName = keyValueSplit[0];
            TimerBucketConfiguration metricBucketConfiguration = null;
            if (keyValueSplit.length == 1) continue;
            Object[] arrDuration = (Duration[])Arrays.asList(keyValueSplit[1].split(",")).stream().map(s -> {
                if ((s = s.trim()).matches("[0-9]+ms")) {
                    String val = s.substring(0, s.length() - 2);
                    return Duration.ofMillis(Long.parseLong(val));
                }
                if (s.matches("[0-9]+s")) {
                    String val = s.substring(0, s.length() - 1);
                    return Duration.ofSeconds(Long.parseLong(val));
                }
                if (s.matches("[0-9]+m")) {
                    String val = s.substring(0, s.length() - 1);
                    return Duration.ofMinutes(Long.parseLong(val));
                }
                if (s.matches("[0-9]+h")) {
                    String val = s.substring(0, s.length() - 1);
                    return Duration.ofHours(Long.parseLong(val));
                }
                if (s.matches("[0-9]+")) {
                    return Duration.ofMillis(Long.parseLong(s));
                }
                Tr.warning((TraceComponent)tc, (String)"invalidTimerValueConfigured.warning.CWMMC0016W", (Object[])new Object[]{s, "mp.metrics.distribution.timer.buckets"});
                return null;
            }).filter(s -> s != null).toArray(Duration[]::new);
            Arrays.sort(arrDuration);
            metricBucketConfiguration = new TimerBucketConfiguration(metricName, (Duration[])arrDuration);
            metricSLOConfiguration.addFirst(metricBucketConfiguration);
        }
        return metricSLOConfiguration;
    }
}

