/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.assertion.StatementValidator;
import org.opensaml.saml.saml2.assertion.impl.AssertionValidationSupport;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthnStatementValidator
implements StatementValidator {
    private Logger log = LoggerFactory.getLogger(AuthnStatementValidator.class);

    @Override
    public QName getServicedStatement() {
        return AuthnStatement.DEFAULT_ELEMENT_NAME;
    }

    @Override
    public ValidationResult validate(@Nonnull Statement statement, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        if (!(statement instanceof AuthnStatement)) {
            this.log.warn("Statement '{}' of type '{}' in assertion '{}' was not an '{}' statement.  Unable to process.", new Object[]{statement.getElementQName(), statement.getSchemaType(), assertion.getID(), this.getServicedStatement()});
            return ValidationResult.INDETERMINATE;
        }
        try {
            AuthnStatement authnStatement = (AuthnStatement)statement;
            ValidationResult result = this.validateAuthnInstant(authnStatement, assertion, context);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateSubjectLocality(authnStatement, assertion, context);
            if (result != ValidationResult.VALID) {
                return result;
            }
            result = this.validateAuthnContext(authnStatement, assertion, context);
            if (result != ValidationResult.VALID) {
                return result;
            }
        }
        catch (RuntimeException | AssertionValidationException e) {
            this.log.warn("There was a problem determining AuthnStatement validity", (Throwable)e);
            return ValidationResult.INDETERMINATE;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateAuthnInstant(@Nonnull AuthnStatement authnStatement, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        Duration maxTimeSinceAuthn = (Duration)context.getStaticParameters().get("saml2.Statement.Authn.MaxTimeSinceAuthn");
        if (maxTimeSinceAuthn == null) {
            this.log.debug("Max time since authn for evaluation of AuthnStatement/@AuthnInstant not supplied, skipping");
            return ValidationResult.VALID;
        }
        this.log.debug("Max time since authn for evaluation of AuthnStatement/@AuthnInstant was: {}", (Object)maxTimeSinceAuthn);
        Instant authnInstant = authnStatement.getAuthnInstant();
        if (authnInstant == null) {
            this.log.warn("AuthnStatement/@AuthnInstant is required but was not supplied, failing");
            return ValidationResult.INVALID;
        }
        Duration clockSkew = SAML20AssertionValidator.getClockSkew(context);
        Instant latestValid = authnInstant.plus(maxTimeSinceAuthn).plus(clockSkew);
        Instant now = Instant.now();
        if (now.isAfter(latestValid)) {
            this.log.warn("AuthnStatement/@AuthnInstant '{}' eval failed, now is after latest valid (including skew) '{}'", (Object)authnInstant, (Object)latestValid);
            return ValidationResult.INVALID;
        }
        return ValidationResult.VALID;
    }

    protected ValidationResult validateSubjectLocality(@Nonnull AuthnStatement authnStatement, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        Boolean checkAddress = (Boolean)context.getStaticParameters().get("saml2.Statement.Authn.SubjectLocality.CheckAddress");
        if (checkAddress != null && !checkAddress.booleanValue()) {
            this.log.debug("SubjectLocality/@Address check is disabled, skipping");
            return ValidationResult.VALID;
        }
        SubjectLocality subjectLocality = authnStatement.getSubjectLocality();
        if (subjectLocality == null || subjectLocality.getAddress() == null) {
            this.log.debug("AuthnStatement contained no SubjectLocality/@Address, skipping");
            return ValidationResult.VALID;
        }
        String address = StringSupport.trimOrNull((String)subjectLocality.getAddress());
        return AssertionValidationSupport.checkAddress(context, address, "saml2.Statement.Authn.SubjectLocality.ValidAddresses", assertion, "SubjectLocality/@Address");
    }

    protected ValidationResult validateAuthnContext(@Nonnull AuthnStatement authnStatement, @Nonnull Assertion assertion, @Nonnull ValidationContext context) throws AssertionValidationException {
        return ValidationResult.VALID;
    }
}

