/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.logic;

import jakarta.annotation.Nonnull;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.annotation.ParameterName;

public final class BiFunctionSupport {
    private BiFunctionSupport() {
    }

    @Nonnull
    public static <T, U, V> BiFunction<T, U, V> constant(@Nonnull @ParameterName(name="target") V target) {
        return (t, u) -> target;
    }

    @Nonnull
    public static <A, B, C, D> BiFunction<A, B, D> compose(@Nonnull @ParameterName(name="g") Function<? super C, ? extends D> g, @Nonnull @ParameterName(name="f") BiFunction<A, B, ? extends C> f) {
        return f.andThen(g);
    }

    @Nonnull
    public static <T, U> BiFunction<T, U, Boolean> forBiPredicate(@Nonnull @ParameterName(name="predicate") BiPredicate<? super T, ? super U> predicate) {
        return predicate::test;
    }

    @Nonnull
    public static <A, B, C> BiFunction<A, B, C> forFunctionOfFirstArg(@Nonnull @ParameterName(name="function") Function<? super A, ? extends C> function) {
        return (a, b) -> function.apply((Object)a);
    }

    @Nonnull
    public static <A, B, C> BiFunction<A, B, C> forFunctionOfSecondArg(@Nonnull @ParameterName(name="function") Function<? super B, ? extends C> function) {
        return (a, b) -> function.apply((Object)b);
    }
}

