/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.org.jboss.resteasy.common.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import io.openliberty.org.jboss.resteasy.common.client.LibertyClientWebTarget;
import io.openliberty.org.jboss.resteasy.common.client.LibertyResteasyClientBuilderImpl;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.jboss.resteasy.client.jaxrs.ClientHttpEngine;
import org.jboss.resteasy.client.jaxrs.ResteasyClient;
import org.jboss.resteasy.client.jaxrs.ResteasyWebTarget;
import org.jboss.resteasy.client.jaxrs.internal.ClientConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientImpl;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@TraceOptions
public class LibertyResteasyClientImpl
extends ResteasyClientImpl {
    private final LibertyResteasyClientBuilderImpl builder;
    private Supplier<ClientHttpEngine> httpEngineSupplier;
    private AtomicReference<ClientHttpEngine> httpEngine = new AtomicReference();
    private final List<Runnable> closeActions;
    static final long serialVersionUID = 6361913723491201263L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    protected LibertyResteasyClientImpl(Supplier<ClientHttpEngine> httpEngine, ExecutorService asyncInvocationExecutor, boolean cleanupExecutor, ScheduledExecutorService scheduledExecutorService, ClientConfiguration configuration, List<Runnable> closeActions, LibertyResteasyClientBuilderImpl builder) {
        super(null, asyncInvocationExecutor, cleanupExecutor, scheduledExecutorService, configuration);
        this.builder = builder;
        this.httpEngineSupplier = httpEngine;
        this.closeActions = closeActions;
    }

    @Override
    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, String uri, ClientConfiguration configuration) {
        return new LibertyClientWebTarget((ResteasyClient)client, uri, configuration, this.builder);
    }

    @Override
    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, URI uri, ClientConfiguration configuration) {
        return new LibertyClientWebTarget((ResteasyClient)client, uri, configuration, this.builder);
    }

    @Override
    protected ResteasyWebTarget createClientWebTarget(ResteasyClientImpl client, UriBuilder uriBuilder, ClientConfiguration configuration) {
        return new LibertyClientWebTarget((ResteasyClient)client, uriBuilder, configuration, this.builder);
    }

    @Override
    public ClientHttpEngine httpEngine() {
        ClientHttpEngine engine = this.httpEngine.get();
        if (engine == null) {
            this.httpEngine.compareAndSet(null, this.httpEngineSupplier.get());
            engine = this.httpEngine.get();
        }
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setAutoFollowRedirects(boolean b) {
        AtomicReference<ClientHttpEngine> atomicReference = this.httpEngine;
        synchronized (atomicReference) {
            if (this.httpEngine.get() == null) {
                Supplier<ClientHttpEngine> originalSupplier = this.httpEngineSupplier;
                this.httpEngineSupplier = () -> {
                    ClientHttpEngine engine = (ClientHttpEngine)originalSupplier.get();
                    engine.setFollowRedirects(b);
                    return engine;
                };
            } else {
                this.httpEngine.get().setFollowRedirects(b);
            }
        }
    }

    @Override
    public void close() {
        this.closed = true;
        try {
            ClientHttpEngine engine = this.httpEngine.get();
            if (engine != null) {
                engine.close();
            }
            if (this.cleanupExecutor) {
                if (System.getSecurityManager() == null) {
                    this.asyncInvocationExecutor.shutdown();
                } else {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){
                        static final long serialVersionUID = 7477409748534364876L;
                        private static final /* synthetic */ TraceComponent $$$tc$$$;

                        @Override
                        public Void run() {
                            LibertyResteasyClientImpl.this.asyncInvocationExecutor.shutdown();
                            return null;
                        }

                        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                        static {
                            $$$tc$$$ = Tr.register((String)"io.openliberty.org.jboss.resteasy.common.client.LibertyResteasyClientImpl$1", 1.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
                        }
                    });
                }
            }
            for (Runnable r : this.closeActions) {
                try {
                    r.run();
                }
                catch (Throwable throwable) {}
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.org.jboss.resteasy.common.client.LibertyResteasyClientImpl", LibertyResteasyClientImpl.class, (String)"RESTfulWS", (String)"io.openliberty.org.jboss.resteasy.common.nls.RESTfulWSServer");
    }
}

