/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.spnego;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.authentication.filter.AuthenticationFilter;
import com.ibm.ws.security.kerberos.auth.KerberosService;
import com.ibm.ws.security.spnego.SpnegoAuthenticator;
import com.ibm.ws.security.spnego.SpnegoConfig;
import com.ibm.ws.security.spnego.internal.SpnegoConfigImpl;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.AuthenticationResult;
import com.ibm.ws.webcontainer.security.WebAuthenticator;
import com.ibm.ws.webcontainer.security.WebRequest;
import com.ibm.wsspi.kernel.service.location.WsLocationAdmin;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={WebAuthenticator.class}, name="com.ibm.ws.security.spnego", configurationPolicy=ConfigurationPolicy.REQUIRE, property={"service.vendor=IBM", "com.ibm.ws.security.webAuthenticator.type=SPNEGO"})
public class SpnegoService
implements WebAuthenticator {
    public static final TraceComponent tc = Tr.register(SpnegoService.class, (String)"spnego", (String)"com.ibm.ws.security.spnego.internal.resources.SpnegoMessages");
    static final String CONFIGURATION_ADMIN = "configurationAdmin";
    public static final String KEY_FILTER = "authenticationFilter";
    private static final String KEY_LOCATION_ADMIN = "locationAdmin";
    private static final String KERB_SERVICE = "kerberosService";
    private final AtomicServiceReference<WsLocationAdmin> locationAdminRef = new AtomicServiceReference("locationAdmin");
    protected final AtomicServiceReference<AuthenticationFilter> authFilterServiceRef = new AtomicServiceReference("authenticationFilter");
    protected final AtomicServiceReference<KerberosService> kerberosServiceRef = new AtomicServiceReference("kerberosService");
    private final AuthenticationResult CONTINUE = new AuthenticationResult(AuthResult.CONTINUE, "SPNEGO service said continue...");
    private SpnegoAuthenticator spnegoAuthenticator = null;
    private SpnegoConfig spnegoConfig = null;
    private final String noSpnGSSCredMsg = TraceNLS.getStringFromBundle(this.getClass(), (String)"com.ibm.ws.security.token.internal.resources.TokenMessages", (String)"SPNEGO_NO_SPN_GSS_CREDENTIAL", (String)"CWWKS4309E: Can not create a GSSCredential for any of the service principal names. All requests will not use SPNEGO authentication.");
    static final long serialVersionUID = 3948125712459231793L;

    @Reference(name="authenticationFilter", service=AuthenticationFilter.class, cardinality=ReferenceCardinality.OPTIONAL, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("authFilter id: " + ref.getProperty("id") + " authFilterRef: " + ref), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.setReference(ref);
    }

    protected void updatedAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        this.authFilterServiceRef.setReference(ref);
    }

    protected void unsetAuthenticationFilter(ServiceReference<AuthenticationFilter> ref) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("authFilter id: " + ref.getProperty("id") + " authFilterRef: " + ref), (Object[])new Object[0]);
        }
        this.authFilterServiceRef.unsetReference(ref);
    }

    @Reference(service=WsLocationAdmin.class, name="locationAdmin", policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void setLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.setReference(ref);
    }

    protected void unsetLocationAdmin(ServiceReference<WsLocationAdmin> ref) {
        this.locationAdminRef.unsetReference(ref);
    }

    @Reference(name="kerberosService", service=KerberosService.class)
    protected void setKerberosService(ServiceReference<KerberosService> ref) {
        this.kerberosServiceRef.setReference(ref);
    }

    protected void unsetKerberosService(ServiceReference<KerberosService> ref) {
        this.kerberosServiceRef.unsetReference(ref);
    }

    @Activate
    protected synchronized void activate(ComponentContext cc, Map<String, Object> props) {
        this.kerberosServiceRef.activate(cc);
        this.locationAdminRef.activate(cc);
        this.authFilterServiceRef.activate(cc);
        this.spnegoConfig = new SpnegoConfigImpl((WsLocationAdmin)this.locationAdminRef.getServiceWithException(), (KerberosService)this.kerberosServiceRef.getServiceWithException(), props);
        this.spnegoAuthenticator = new SpnegoAuthenticator();
        Tr.info((TraceComponent)tc, (String)"SPNEGO_CONFIG_PROCESSED", (Object[])new Object[]{this.spnegoConfig.getId()});
    }

    @Modified
    protected synchronized void modified(Map<String, Object> props) {
        this.spnegoConfig = new SpnegoConfigImpl((WsLocationAdmin)this.locationAdminRef.getServiceWithException(), (KerberosService)this.kerberosServiceRef.getServiceWithException(), props);
        Tr.info((TraceComponent)tc, (String)"SPNEGO_CONFIG_MODIFIED", (Object[])new Object[]{this.spnegoConfig.getId()});
    }

    @Deactivate
    protected synchronized void deactivate(ComponentContext cc) {
        this.locationAdminRef.deactivate(cc);
        this.authFilterServiceRef.deactivate(cc);
        this.kerberosServiceRef.deactivate(cc);
        this.spnegoConfig = null;
        this.spnegoAuthenticator = null;
    }

    public void setSpnegoConfig(SpnegoConfig spnegoConfig) {
        this.spnegoConfig = spnegoConfig;
    }

    public void setSpnegoAuthenticator(SpnegoAuthenticator spnegoAuthenticator) {
        this.spnegoAuthenticator = spnegoAuthenticator;
    }

    public AuthenticationResult authenticate(WebRequest webRequest) {
        boolean isFirstRequest;
        HttpServletRequest req = webRequest.getHttpServletRequest();
        HttpServletResponse resp = webRequest.getHttpServletResponse();
        String authzHeader = req.getHeader("Authorization");
        boolean bl = isFirstRequest = authzHeader == null;
        if (!this.shouldSpnegoAuthenticateThisRequest(webRequest, req, isFirstRequest)) {
            return this.CONTINUE;
        }
        if (isFirstRequest) {
            return this.spnegoAuthenticator.createNegotiateHeader(resp, this.spnegoConfig);
        }
        AuthenticationResult result = null;
        if (!this.spnegoConfig.isSpnGssCredentialEmpty()) {
            result = this.spnegoAuthenticator.authenticate(req, resp, authzHeader, this.spnegoConfig);
            if (result != null && (result.getStatus() == AuthResult.CONTINUE || result.getStatus() == AuthResult.SUCCESS)) {
                return result;
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No GSSCredential for any of the service principal names.", (Object[])new Object[0]);
            }
            result = this.spnegoAuthenticator.spnegoAuthenticationErrorPage(resp, this.spnegoConfig, this.noSpnGSSCredMsg);
        }
        if (!this.spnegoConfig.getDisableFailOverToAppAuthType()) {
            result = this.CONTINUE;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"failOverToAppAuthType is allowed, so continue...", (Object[])new Object[0]);
            }
        }
        return result;
    }

    protected boolean shouldSpnegoAuthenticateThisRequest(WebRequest webRequest, HttpServletRequest req, boolean isFirstRequest) {
        if (isFirstRequest && webRequest.isUnprotectedURI() && !webRequest.isProviderSpecialUnprotectedURI()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"un-protectedURI request and no SPNEGO token so do not authenticate with SPNEGO web", (Object[])new Object[0]);
            }
            return false;
        }
        if (webRequest.isCallAfterSSO() && this.spnegoConfig.isInvokeAfterSSO() || !webRequest.isCallAfterSSO() && !this.spnegoConfig.isInvokeAfterSSO()) {
            return this.isAuthFilterAccept(req);
        }
        return false;
    }

    protected boolean isAuthFilterAccept(HttpServletRequest req) {
        AuthenticationFilter authFilter = (AuthenticationFilter)this.authFilterServiceRef.getService();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("authFilter:" + authFilter), (Object[])new Object[0]);
        }
        if (authFilter != null) {
            return authFilter.isAccepted(req);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Authentication filter service is not avaliale, all HTTP requests will use SPNEGO authentication", (Object[])new Object[0]);
        }
        return true;
    }

    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, HashMap props) throws Exception {
        return null;
    }
}

