/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.clients.common;

import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ssl.SSLException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.ssl.NoSSLSocketFactoryException;
import com.ibm.ws.security.common.structures.BoundedHashMap;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.pkce.ProofKeyForCodeExchangeHelper;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.oidcclientcore.exceptions.TokenEndpointAuthMethodSettingsException;
import io.openliberty.security.oidcclientcore.http.BadPostRequestException;
import io.openliberty.security.oidcclientcore.http.OidcClientHttpUtil;
import io.openliberty.security.oidcclientcore.token.TokenRequestor;
import io.openliberty.security.oidcclientcore.token.TokenResponse;
import io.openliberty.security.oidcclientcore.token.auth.PrivateKeyJwtAuthMethod;
import io.openliberty.security.oidcclientcore.token.auth.TokenEndpointAuthMethod;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AuthorizationCodeHandler {
    private static final TraceComponent tc = Tr.register(AuthorizationCodeHandler.class, (String)"OPENIDCONNECT", (String)"com.ibm.ws.security.openidconnect.clients.common.resources.OidcClientMessages");
    private final HttpServletRequest request;
    private final HttpServletResponse response;
    private final ConvergedClientConfig clientConfig;
    private final String configId;
    private final String clientId;
    private OidcClientUtil oidcClientUtil = null;
    private OIDCClientAuthenticatorUtil authenticatorUtil = null;
    private SSLSupport sslSupport = null;
    private Jose4jUtil jose4jUtil = null;
    private static Map<String, Object> usedAuthCodes = Collections.synchronizedMap(new BoundedHashMap(20));
    static final long serialVersionUID = 2097141449221156908L;

    public AuthorizationCodeHandler(HttpServletRequest request, HttpServletResponse response, ConvergedClientConfig clientConfig, SSLSupport sslsupt) {
        this.request = request;
        this.response = response;
        this.clientConfig = clientConfig;
        this.clientId = clientConfig.getClientId();
        this.configId = clientConfig.getId();
        this.oidcClientUtil = this.getOidcClientUtil();
        this.authenticatorUtil = this.getOIDCClientAuthenticatorUtil();
        this.sslSupport = sslsupt;
        this.jose4jUtil = this.getJose4jUtil(this.sslSupport);
    }

    protected OidcClientUtil getOidcClientUtil() {
        return new OidcClientUtil();
    }

    protected OIDCClientAuthenticatorUtil getOIDCClientAuthenticatorUtil() {
        return new OIDCClientAuthenticatorUtil();
    }

    protected Jose4jUtil getJose4jUtil(SSLSupport sslSupport) {
        return new Jose4jUtil(sslSupport);
    }

    public ProviderAuthenticationResult handleAuthorizationCode(String authzCode, String responseState) {
        OidcClientRequest oidcClientRequest = (OidcClientRequest)this.request.getAttribute("com.ibm.wsspi.security.oidc.client.request");
        ProviderAuthenticationResult oidcResult = null;
        oidcResult = this.authenticatorUtil.verifyResponseState(this.request, this.response, responseState, this.clientConfig);
        if (oidcResult != null) {
            return oidcResult;
        }
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(this.clientConfig, this.clientConfig.getTokenEndpointUrl())) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{this.clientConfig.getTokenEndpointUrl()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        String redirectUrl = OIDCClientAuthenticatorUtil.setRedirectUrlIfNotDefined(this.request, this.clientConfig);
        if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement(this.clientConfig, redirectUrl)) {
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", (Object[])new Object[]{redirectUrl});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return this.getAndValidateTokens(oidcClientRequest, authzCode, responseState, redirectUrl);
    }

    ProviderAuthenticationResult getAndValidateTokens(OidcClientRequest oidcClientRequest, String authzCode, String responseState, String redirectUrl) {
        ProviderAuthenticationResult oidcResult = null;
        SSLSocketFactory sslSocketFactory = null;
        try {
            sslSocketFactory = this.getSSLSocketFactory();
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"113", (Object)this, (Object[])new Object[]{oidcClientRequest, authzCode, responseState, redirectUrl});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        try {
            oidcResult = this.sendTokenRequestAndValidateResult(oidcClientRequest, sslSocketFactory, authzCode, responseState, redirectUrl);
        }
        catch (BadPostRequestException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"118", (Object)this, (Object[])new Object[]{oidcClientRequest, authzCode, responseState, redirectUrl});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_TOKEN_REQUEST_FAILURE", (Object[])new Object[]{e.getMessage(), this.configId, this.clientConfig.getTokenEndpointUrl()});
            this.sendErrorJSON(e.getStatusCode(), "invalid_request", e.getMessage());
            return new ProviderAuthenticationResult(AuthResult.FAILURE, e.getStatusCode());
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"122", (Object)this, (Object[])new Object[]{oidcClientRequest, authzCode, responseState, redirectUrl});
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_TOKEN_REQUEST_FAILURE", (Object[])new Object[]{e.getLocalizedMessage(), this.configId, this.clientConfig.getTokenEndpointUrl()});
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        return oidcResult;
    }

    /*
     * WARNING - void declaration
     */
    SSLSocketFactory getSSLSocketFactory() throws SSLException, NoSSLSocketFactoryException {
        SSLSocketFactory sslSocketFactory = null;
        boolean throwExc = this.clientConfig.getTokenEndpointUrl() != null && this.clientConfig.getTokenEndpointUrl().startsWith("https");
        try {
            sslSocketFactory = new OidcClientHttpUtil().getSSLSocketFactory(this.clientConfig.getSSLConfigurationName(), this.sslSupport);
        }
        catch (SSLException sSLException) {
            void e;
            FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"134", (Object)this, (Object[])new Object[0]);
            Tr.error((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{e, this.configId});
            throw e;
        }
        catch (NoSSLSocketFactoryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"137", (Object)this, (Object[])new Object[0]);
            String nlsMessage = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", this.configId});
            Tr.error((TraceComponent)tc, (String)nlsMessage, (Object[])new Object[0]);
            if (throwExc) {
                throw new SSLException(nlsMessage);
            }
            throw e;
        }
        return sslSocketFactory;
    }

    ProviderAuthenticationResult sendTokenRequestAndValidateResult(OidcClientRequest oidcClientRequest, SSLSocketFactory sslSocketFactory, String authzCode, String responseState, String redirectUrl) throws MalformedURLException, Exception {
        String url = this.clientConfig.getTokenEndpointUrl();
        if (url == null || url.length() == 0) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_NULL_TOKEN_ENDPOINT", (Object[])new Object[]{this.configId});
            throw new MalformedURLException(message);
        }
        TokenRequestor.Builder tokenRequestBuilder = new TokenRequestor.Builder(url, this.clientId, this.clientConfig.getClientSecret(), redirectUrl, authzCode);
        tokenRequestBuilder.sslSocketFactory(sslSocketFactory);
        tokenRequestBuilder.grantType(this.clientConfig.getGrantType());
        tokenRequestBuilder.isHostnameVerification(this.clientConfig.isHostNameVerificationEnabled());
        tokenRequestBuilder.resources(OIDCClientAuthenticatorUtil.getResources(this.clientConfig));
        tokenRequestBuilder.customParams(this.getTokenRequestCustomParameters(responseState));
        tokenRequestBuilder.useSystemPropertiesForHttpClientConnections(this.clientConfig.getUseSystemPropertiesForHttpClientConnections());
        String tokenEndpointAuthMethod = this.clientConfig.getTokenEndpointAuthMethod();
        tokenRequestBuilder.authMethod(tokenEndpointAuthMethod);
        tokenRequestBuilder.originHeaderValue(this.clientConfig.getTokenRequestOriginHeader());
        this.setAuthMethodSpecificSettings(tokenRequestBuilder, tokenEndpointAuthMethod);
        TokenRequestor tokenRequestor = tokenRequestBuilder.build();
        TokenResponse tokenResponse = tokenRequestor.requestTokens();
        Map tokens = tokenResponse.asMap();
        oidcClientRequest.setTokenType("ID Token");
        ProviderAuthenticationResult oidcResult = this.jose4jUtil.createResultWithJose4J(responseState, tokens, this.clientConfig, oidcClientRequest, sslSocketFactory);
        this.addAuthCodeToUsedList(authzCode);
        return oidcResult;
    }

    HashMap<String, String> getTokenRequestCustomParameters(String state) {
        HashMap<String, String> customParams = this.clientConfig.getTokenRequestParams();
        String codeChallengeMethod = this.clientConfig.getPkceCodeChallengeMethod();
        if (codeChallengeMethod != null && !"disabled".equals(codeChallengeMethod)) {
            customParams = this.addPkceParameters(state, customParams);
        }
        return customParams;
    }

    HashMap<String, String> addPkceParameters(String state, HashMap<String, String> parameters) {
        ProofKeyForCodeExchangeHelper pkceHelper = new ProofKeyForCodeExchangeHelper();
        return pkceHelper.addCodeVerifierToTokenRequestParameters(state, parameters);
    }

    void setAuthMethodSpecificSettings(TokenRequestor.Builder tokenRequestBuilder, String tokenEndpointAuthMethod) throws TokenEndpointAuthMethodSettingsException {
        TokenEndpointAuthMethod authMethod = this.getTokenEndpointAuthMethodInstance(tokenEndpointAuthMethod, this.clientConfig);
        if (authMethod == null) {
            return;
        }
        authMethod.setAuthMethodSpecificSettings(tokenRequestBuilder);
    }

    TokenEndpointAuthMethod getTokenEndpointAuthMethodInstance(String authMethod, ConvergedClientConfig clientConfig) throws TokenEndpointAuthMethodSettingsException {
        if (authMethod == null || authMethod.isEmpty()) {
            return null;
        }
        if ("private_key_jwt".equals(authMethod)) {
            return new PrivateKeyJwtAuthMethod(clientConfig.getId(), this.clientId, clientConfig.getTokenEndpointUrl(), clientConfig.getTokenEndpointAuthSigningAlgorithm(), clientConfig.getTrustStoreRef(), clientConfig.getSslRef(), clientConfig.getKeyAliasName());
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private void sendErrorJSON(int statusCode, String errorCode, String errorDescription) {
        block8: {
            String error = "error";
            String error_description = "error_description";
            try {
                if (errorCode != null) {
                    this.response.setStatus(statusCode);
                    this.response.setHeader("Content-Type", "application/json;charset=UTF-8");
                    JSONObject responseJSON = new JSONObject();
                    responseJSON.put((Object)"error", (Object)errorCode);
                    if (errorDescription != null) {
                        responseJSON.put((Object)"error_description", (Object)errorDescription);
                    }
                    PrintWriter pw = this.response.getWriter();
                    pw.write(responseJSON.toString());
                    pw.flush();
                } else {
                    this.response.sendError(statusCode);
                }
            }
            catch (IOException responseJSON) {
                FFDCFilter.processException((Throwable)responseJSON, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"232", (Object)this, (Object[])new Object[]{statusCode, errorCode, errorDescription});
                if (tc.isDebugEnabled()) {
                    void e;
                    Tr.debug((TraceComponent)tc, (String)"Internal error sending error message", (Object[])new Object[]{e});
                }
                try {
                    this.response.sendError(500);
                }
                catch (IOException pw) {
                    void ioe;
                    FFDCFilter.processException((Throwable)pw, (String)"com.ibm.ws.security.openidconnect.clients.common.AuthorizationCodeHandler", (String)"237", (Object)this, (Object[])new Object[]{statusCode, errorCode, errorDescription});
                    if (!tc.isDebugEnabled()) break block8;
                    Tr.debug((TraceComponent)tc, (String)"yet another internal error, give up", (Object[])new Object[]{ioe});
                }
            }
        }
    }

    boolean isAuthCodeReused(String authzCode) {
        return usedAuthCodes.containsKey(authzCode);
    }

    void addAuthCodeToUsedList(String authzCode) {
        usedAuthCodes.put(authzCode, null);
    }
}

