/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import io.reactivex.internal.subscriptions.DeferredScalarSubscription;
import io.reactivex.internal.subscriptions.SubscriptionHelper;
import io.reactivex.plugins.RxJavaPlugins;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class CollectorSubscriber<T, A, R>
extends DeferredScalarSubscription<R>
implements Subscriber<T> {
    private static final long serialVersionUID = 2129956429647866525L;
    private final transient BiConsumer<A, T> accumulator;
    private final transient Function<A, R> finisher;
    private transient A intermediate;
    private transient Subscription subscription;
    private boolean done;

    CollectorSubscriber(Subscriber<? super R> actual, A initialValue, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
        super(actual);
        this.intermediate = initialValue;
        this.accumulator = accumulator;
        this.finisher = finisher;
    }

    public void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate((Subscription)this.subscription, (Subscription)s)) {
            this.subscription = s;
            this.downstream.onSubscribe((Subscription)this);
            s.request(Long.MAX_VALUE);
        }
    }

    public void onNext(T t) {
        if (!this.done) {
            try {
                this.accumulator.accept(this.intermediate, t);
            }
            catch (Exception ex) {
                this.subscription.cancel();
                this.onError(ex);
            }
        }
    }

    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError((Throwable)t);
        } else {
            this.done = true;
            this.intermediate = null;
            this.downstream.onError(t);
        }
    }

    public void onComplete() {
        if (!this.done) {
            R r;
            try {
                r = this.finisher.apply(this.intermediate);
            }
            catch (Exception ex) {
                this.onError(ex);
                return;
            }
            this.intermediate = null;
            this.complete(r);
        }
    }

    public void cancel() {
        super.cancel();
        this.subscription.cancel();
    }
}

