/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.opentracing30.internal.rest.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.opentracing.internal.OpentracingClientFilter;
import jakarta.annotation.Priority;
import jakarta.ws.rs.client.ClientRequestContext;
import jakarta.ws.rs.client.ClientRequestFilter;
import java.io.IOException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.opentracing.Traced;

@Priority(value=-2147483647)
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpentracingRestClient30Filter
implements ClientRequestFilter {
    private static final TraceComponent tc = Tr.register(OpentracingRestClient30Filter.class, (String)"OPENTRACING", null);
    static final long serialVersionUID = 8401852969555730931L;

    public void filter(ClientRequestContext clientRequestContext) throws IOException {
        Method method;
        Traced traced;
        Object invokedMethod = clientRequestContext.getProperty("org.eclipse.microprofile.rest.client.invokedMethod");
        if (invokedMethod != null && (traced = (method = (Method)invokedMethod).getAnnotation(Traced.class)) != null && !traced.value()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)("@Traced(false) on method " + method.getName()), (Object[])new Object[0]);
            }
            clientRequestContext.setProperty(OpentracingClientFilter.CLIENT_FILTER_ENABLED_ID, (Object)false);
        }
    }
}

