/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transport.GenericEndpointImpl;
import com.ibm.ws.sip.stack.transport.netty.SipMessageBufferStreamDecoder;
import com.ibm.ws.sip.stack.transport.sip.netty.SipConnLink;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import com.ibm.ws.sip.stack.util.AddressUtils;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.SslHandler;
import io.openliberty.netty.internal.BootstrapExtended;
import io.openliberty.netty.internal.NettyFramework;
import io.openliberty.netty.internal.exception.NettyException;
import jain.protocol.ip.sip.ListeningPoint;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Collections;
import java.util.Map;

public abstract class SipOutboundConnLink
extends SipConnLink {
    private static final TraceComponent tc = Tr.register(SipOutboundConnLink.class);
    private static SipOutboundConnLink s_current = null;
    private static int s_connectTimeout = SIPTransactionStack.instance().getConfiguration().getConnectTimeout();
    private final String m_chainName;
    private BootstrapExtended bootstrap;
    private NettyFramework nettyFw;

    public SipOutboundConnLink(final String peerHost, final int peerPort, SipInboundChannel sipInboundChannel, Channel channel, final boolean isSecure) {
        super(peerHost, peerPort, sipInboundChannel, channel);
        this.m_chainName = sipInboundChannel.getOutboundChainName();
        Map tcpOpt = Collections.emptyMap();
        this.nettyFw = GenericEndpointImpl.getNettyBundle();
        try {
            this.bootstrap = this.nettyFw.createTCPBootstrapOutbound(tcpOpt);
            this.bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)s_connectTimeout);
            this.bootstrap.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

                public void initChannel(SocketChannel ch) throws Exception {
                    ChannelPipeline pipeline = ch.pipeline();
                    if (isSecure) {
                        SslHandler handler = GenericEndpointImpl.getTlsProvider().getOutboundSSLContext(GenericEndpointImpl.getSslOptions(), peerHost, Integer.toString(peerPort), (Channel)ch);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"SipOutboundConnLink", (Object[])new Object[]{"handler: " + handler});
                        }
                        pipeline.addFirst("ssl", (ChannelHandler)handler);
                    }
                    pipeline.addLast("decoder", (ChannelHandler)new SipMessageBufferStreamDecoder());
                    pipeline.addLast("handler", (ChannelHandler)new SipStreamHandler());
                }
            });
        }
        catch (NettyException e2) {
            e2.printStackTrace();
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        InetSocketAddress localBindAddress = this.getLocalAddress();
        InetSocketAddress remoteAddress = this.getRemoteAddress();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"Connecting from [" + localBindAddress + "] to [" + remoteAddress + ']'});
        }
        ChannelFuture channelFuture = null;
        try {
            channelFuture = this.bootstrap.connect((SocketAddress)remoteAddress, (SocketAddress)localBindAddress).sync();
        }
        catch (Exception e2) {
            e2.printStackTrace();
            this.close();
            throw new IOException(e2);
        }
        if (channelFuture.isCancelled() || !channelFuture.isSuccess()) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"connection can't be established: " + channelFuture.cause()});
            }
            this.close();
            throw new IOException(channelFuture.cause());
        }
        Class<SipOutboundConnLink> clazz = SipOutboundConnLink.class;
        synchronized (SipOutboundConnLink.class) {
            s_current = this;
            // ** MonitorExit[var4_5] (shouldn't be in output)
            this.m_channel = channelFuture.channel();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)tc, (String)"connect", (Object[])new Object[]{"connection established successfully: " + remoteAddress});
            }
            this.connectionEstablished();
            return;
        }
    }

    static SipOutboundConnLink getPendingConnection() {
        SipOutboundConnLink current = s_current;
        s_current = null;
        return current;
    }

    private InetSocketAddress getLocalAddress() {
        InetSocketAddress returnValue = null;
        ListeningPoint lp = this.getSIPListenningConnection().getListeningPoint();
        String localBindAddress = lp.getHost();
        if (!AddressUtils.isIpAddress(localBindAddress)) {
            localBindAddress = "0.0.0.0";
        }
        returnValue = new InetSocketAddress(localBindAddress, 0);
        return returnValue;
    }

    private InetSocketAddress getRemoteAddress() {
        InetSocketAddress returnValue = null;
        String host = this.getRemoteHost();
        int port = this.getRemotePort();
        returnValue = new InetSocketAddress(host, port);
        return returnValue;
    }

    private class SipStreamHandler
    extends SimpleChannelInboundHandler<SipMessageByteBuffer> {
        private SipStreamHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelActive", (Object[])new Object[]{ctx.channel().remoteAddress() + " connected"});
            }
        }

        protected void channelRead0(ChannelHandlerContext ctx, SipMessageByteBuffer msg) throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelRead0", (Object[])new Object[]{ctx.channel() + ". [" + msg.getMarkedBytesNumber() + "] bytes received"});
            }
            SipOutboundConnLink.this.complete(msg);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"channelInactive", (Object[])new Object[]{ctx.channel().remoteAddress() + " has been disconnected"});
            }
            SipOutboundConnLink.this.destroy(null);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"exceptionCaught", (Object[])new Object[]{cause});
            }
            SipOutboundConnLink.this.connectionError(new Exception(cause));
            ctx.close();
        }
    }
}

