/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transport.sip.netty;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sip.container.pmi.PerformanceMgr;
import com.ibm.ws.sip.parser.MessageParser;
import com.ibm.ws.sip.parser.StreamMessageParser;
import com.ibm.ws.sip.stack.context.MessageContext;
import com.ibm.ws.sip.stack.transaction.SIPTransactionStack;
import com.ibm.ws.sip.stack.transaction.transport.UseCompactHeaders;
import com.ibm.ws.sip.stack.transaction.transport.connections.SipMessageByteBuffer;
import com.ibm.ws.sip.stack.transport.sip.netty.BaseConnection;
import com.ibm.ws.sip.stack.transport.sip.netty.SipInboundChannel;
import com.ibm.ws.sip.stack.util.StackTaskDurationMeasurer;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;

public abstract class SipConnLink
extends BaseConnection
implements ChannelFutureListener {
    private static final TraceComponent tc = Tr.register(SipConnLink.class);
    final LinkedList<MessageContext> m_outMessages;
    private boolean m_sendPending;
    private MessageParser m_messageParser;
    private static final int READ_BUFFER_SIZE = 2048;
    private IOException m_readError;
    private boolean m_closing;
    private boolean m_broken;
    protected Channel m_channel;
    private static final int s_maxOutboundPendingMessages = SIPTransactionStack.instance().getConfiguration().getMaxOutboundPendingMessages();

    public SipConnLink(SipInboundChannel sipInboundChannel, Channel channel) {
        this(null, 0, sipInboundChannel, channel);
    }

    public SipConnLink(String peerHost, int peerPort, SipInboundChannel sipInboundChannel, Channel channel) {
        super(peerHost, peerPort, sipInboundChannel);
        this.m_channel = channel;
        this.m_outMessages = new LinkedList();
        this.m_sendPending = false;
        this.m_messageParser = new StreamMessageParser(this);
        this.m_readError = null;
        this.m_closing = false;
        this.m_broken = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void connectionEstablished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[0]);
        }
        this.logConnection();
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            super.connectionEstablished();
            this.sendPendingMessages();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[]{"exit"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(MessageContext messageContext, boolean considerMtu, UseCompactHeaders useCompactHeaders) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionEstablished", (Object[])new Object[]{"entry [" + System.identityHashCode(messageContext) + ']'});
        }
        this.logConnection();
        this.prepareBuffer(messageContext, considerMtu, useCompactHeaders);
        try {
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                boolean empty;
                if (PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled() && messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"start measuring task duration"});
                    }
                    messageContext.setStackTaskDurationMeasurer(new StackTaskDurationMeasurer());
                    messageContext.getSipContainerQueueDuration().startMeasuring();
                }
                if (messageContext != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task queued"});
                    }
                    PerformanceMgr.getInstance().updateQueueMonitoringTaskQueuedInOutboundQueue();
                }
                boolean bl = empty = !this.m_sendPending && this.m_outMessages.isEmpty();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending + ", m_outMessages.isEmpty() = " + this.m_outMessages.isEmpty() + ", isConnected() = " + this.isConnected() + ", isClosed() = " + this.isClosed() + ", m_closing = " + this.m_closing});
                }
                if (empty && this.isConnected() && !this.m_closing) {
                    if (this.sendNow(messageContext)) {
                        messageContext.writeComplete();
                    }
                } else {
                    if (this.isClosed()) {
                        String exceptionMessage = "connection is closed: " + this + " could not send messsage: " + messageContext.getSipMessage();
                        throw new IOException(exceptionMessage);
                    }
                    if (this.m_closing) {
                        String exceptionMessage = "connection is closing: " + this + " could not send messsage: " + messageContext.getSipMessage();
                        throw new IOException(exceptionMessage);
                    }
                    if (s_maxOutboundPendingMessages > 0 && this.m_outMessages.size() >= s_maxOutboundPendingMessages) {
                        String exceptionMessage = "too many [" + this.m_outMessages.size() + "] outbound messages pending on [" + this + ']';
                        throw new IOException(exceptionMessage);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"adding messageContext = " + messageContext + "\n to m_outMessages"});
                    }
                    this.m_outMessages.addLast(messageContext);
                }
            }
        }
        catch (IOException e2) {
            this.connectionError(e2);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"write", (Object[])new Object[]{"exit [" + System.identityHashCode(messageContext) + ']'});
        }
    }

    private boolean sendNow(MessageContext messageContext) throws IOException {
        boolean complete;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"entry [" + System.identityHashCode(messageContext) + ']'});
        }
        if (PerformanceMgr.getInstance().isTaskDurationOutboundQueuePMIEnabled() && messageContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"measure task duration"});
            }
            PerformanceMgr.getInstance().measureTaskDurationOutboundQueue(messageContext.getSipContainerQueueDuration().takeTimeMeasurement());
        }
        if (messageContext != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"update QueueMonitoring outbound queue statistics - task dequeued"});
            }
            PerformanceMgr.getInstance().updateQueueMonitoringTaskDequeuedFromOutboundQueue();
        }
        SipMessageByteBuffer sipBuffer = messageContext.getSipMessageByteBuffer();
        messageContext.setSipMessageByteBuffer(null);
        ByteBuf buffer = SipConnLink.stackBufferToByteBuf(sipBuffer);
        ChannelFuture writeFuture = this.m_channel.writeAndFlush((Object)buffer);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendNow", (Object[])new Object[]{"exit [" + System.identityHashCode(messageContext) + ']'});
        }
        if (!(complete = writeFuture.isDone())) {
            writeFuture.addListener((GenericFutureListener)messageContext);
        }
        return complete;
    }

    @Override
    public MessageParser getMessageParser() {
        return this.m_messageParser;
    }

    public void destroy(Exception e2) {
        this.connectionError(e2);
    }

    public void destroy() {
        this.connectionError(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeComplete(MessageContext messageContext) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeComplete", (Object[])new Object[]{"entry [" + System.identityHashCode(messageContext) + ']'});
        }
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            this.m_sendPending = false;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeComplete", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending});
            }
            if (this.m_readError == null) {
                this.sendPendingMessages();
            } else {
                IOException readError = this.m_readError;
                this.m_readError = null;
                this.connectionError(readError);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeComplete", (Object[])new Object[]{"exit"});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendPendingMessages() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[0]);
        }
        this.logConnection();
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            try {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"m_sendPending = " + this.m_sendPending + "m_outMessages.isEmpty() = " + this.m_outMessages.isEmpty()});
                }
                while (!this.m_sendPending && !this.m_outMessages.isEmpty()) {
                    MessageContext messageSendingContext;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"sending pending messages"});
                    }
                    if (!this.sendNow(messageSendingContext = this.m_outMessages.removeFirst())) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"send will complete later"});
                        break;
                    }
                    messageSendingContext.writeComplete();
                }
                if (this.m_closing && !this.m_sendPending && this.m_outMessages.isEmpty()) {
                    this.close();
                }
            }
            catch (IOException e2) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[]{"IOException", e2});
                }
                this.connectionError(e2);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sendPendingMessages", (Object[])new Object[0]);
        }
    }

    public void complete(SipMessageByteBuffer buffer) {
        this.messageReceived(buffer);
    }

    public void operationComplete(ChannelFuture arg0) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void error(IOException e2) {
        boolean empty;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"error", (Object[])new Object[]{"error received from TCP"});
        }
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            empty = this.m_outMessages.isEmpty();
        }
        if (empty) {
            this.connectionError(e2);
        } else {
            this.m_readError = e2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"close", (Object[])new Object[]{"[" + this + "] closed [" + this.isClosed() + "] closing [" + this.m_closing + "] broken [" + this.m_broken + ']'});
        }
        this.logConnection();
        if (this.isClosed()) {
            return;
        }
        if (!this.m_broken) {
            LinkedList<MessageContext> linkedList = this.m_outMessages;
            synchronized (linkedList) {
                if (this.m_sendPending || !this.m_outMessages.isEmpty()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close", (Object[])new Object[]{"Waiting for outbound messages pending on [" + this + ']'});
                    }
                    this.m_closing = true;
                    return;
                }
            }
        }
        super.close();
        if (this.m_channel != null) {
            this.m_channel.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connectionError(Exception e2) {
        ArrayList<MessageContext> pendingMessageContextList;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionError", (Object[])new Object[0]);
        }
        this.logConnection();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionError", (Object[])new Object[]{"error", e2});
        }
        this.m_broken = true;
        if (!this.isClosed()) {
            super.connectionError(e2);
        }
        LinkedList<MessageContext> linkedList = this.m_outMessages;
        synchronized (linkedList) {
            pendingMessageContextList = new ArrayList<MessageContext>(this.m_outMessages);
            this.m_outMessages.clear();
        }
        this.cleanPendingMessages(pendingMessageContextList, e2);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"connectionError", (Object[])new Object[0]);
        }
    }
}

