/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.was.filters;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.websphere.servlet.event.ServletEvent;
import com.ibm.websphere.servlet.event.ServletListener;
import com.ibm.ws.sip.container.osgi.ServletInstanceHolderFactory;
import com.ibm.ws.sip.container.parser.SipAppDesc;
import com.ibm.ws.sip.container.router.SipAppDescManager;
import com.ibm.ws.sip.container.servlets.SipApplicationSessionImpl;
import com.ibm.ws.sip.container.servlets.SipServletMessageImpl;
import com.ibm.ws.sip.container.servlets.SipServletRequestImpl;
import com.ibm.ws.sip.container.servlets.SipServletResponseImpl;
import com.ibm.ws.sip.container.tu.TransactionUserWrapper;
import com.ibm.ws.sip.container.was.ThreadLocalStorage;
import com.ibm.ws.sip.container.was.message.SipMessage;

public class SipServletListener
implements ServletListener {
    private static final LogMgr c_logger = Log.get(SipServletListener.class);

    public void onServletAvailableForService(ServletEvent servletevent) {
    }

    public void onServletFinishDestroy(ServletEvent servletevent) {
    }

    public void onServletFinishInit(ServletEvent servletevent) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "onServletFinishInit", (Object)servletevent);
        }
        SipServletRequestImpl sipRequest = null;
        SipServletResponseImpl sipResponse = null;
        int index = -1;
        SipMessage msg = ThreadLocalStorage.getSipMessage();
        if (msg != null) {
            sipResponse = (SipServletResponseImpl)msg.getResponse();
            sipRequest = (SipServletRequestImpl)msg.getRequest();
            SipServletMessageImpl message = sipResponse != null ? sipResponse : sipRequest;
            TransactionUserWrapper tu = message.getTransactionUser();
            SipApplicationSessionImpl appSess = tu.getAppSessionForInternalUse();
            index = appSess != null ? appSess.extractAppSessionCounter() : SipApplicationSessionImpl.extractAppSessionCounter(tu.getApplicationId());
            if (c_logger.isTraceDebugEnabled()) {
                c_logger.traceDebug(this, "onServletFinishInit", "found queue index: " + index);
            }
            ServletInstanceHolderFactory.getInstanceHolder().triggerSipletInitServlet(index);
        } else {
            boolean isLoadOnStartServlet = false;
            for (SipAppDesc appDesc : SipAppDescManager.getInstance().getSipAppDescs()) {
                if (appDesc.getSipServlet(servletevent.getServletName()) == null) continue;
                ServletInstanceHolderFactory.getInstanceHolder().saveOnStartupServlet();
                isLoadOnStartServlet = true;
                break;
            }
            if (c_logger.isTraceDebugEnabled()) {
                if (isLoadOnStartServlet) {
                    c_logger.traceDebug(this, "onServletFinishInit", "Siplet is load on startup Servlet. Firing the event, servletName: " + servletevent.getServletName());
                } else {
                    c_logger.traceDebug(this, "onServletFinishInit", "Siplet isn't load on startup. Ignoring the event, servletName: " + servletevent.getServletName());
                }
            }
        }
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntryExit((Object)this, "onServletFinishInit", null);
        }
    }

    public void onServletStartDestroy(ServletEvent servletevent) {
    }

    public void onServletStartInit(ServletEvent servletevent) {
        if (c_logger.isTraceEntryExitEnabled()) {
            c_logger.traceEntry((Object)this, "onServletStartInit", (Object)servletevent);
        }
    }

    public void onServletUnavailableForService(ServletEvent servletevent) {
    }

    public void onServletUnloaded(ServletEvent servletevent) {
    }
}

