/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.container.load;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;

public class CounterArray {
    private static final LogMgr c_logger = Log.get(CounterArray.class);
    private long[] _cellsArray;
    private int _cellsArraySize = 10;
    private static final int MINIMUM_CELLS_ARRAY_SIZE = 10;
    private int _lastUpdatedIndex = -1;
    private int _averagePeriod;
    private long _lastSummery = -1L;
    private long _lastAverage = -1L;
    private boolean _isArrayFull = false;
    private StringBuffer _myInfo = new StringBuffer();

    public CounterArray(int averagePeriodMsec) {
        this._averagePeriod = averagePeriodMsec < 1000 ? 1 : averagePeriodMsec / 1000;
        if (this._averagePeriod > 10) {
            this._cellsArraySize = this._averagePeriod;
        }
        this._cellsArray = new long[this._cellsArraySize];
        this._myInfo.append(" AveragePeriod = ");
        this._myInfo.append(this._averagePeriod);
        this._myInfo.append(" CellsArraySize = ");
        this._myInfo.append(this._cellsArraySize);
    }

    public long getAverage() {
        this.calculateAverage();
        return this._lastAverage;
    }

    public void addCounter(long counter) {
        if (this._lastUpdatedIndex < this._cellsArraySize - 1) {
            ++this._lastUpdatedIndex;
        } else {
            if (!this._isArrayFull) {
                this._isArrayFull = true;
            }
            this._lastUpdatedIndex = 0;
        }
        this.calculateSummery(this._lastUpdatedIndex, counter);
        this._cellsArray[this._lastUpdatedIndex] = counter;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        for (int i = 0; i < this._cellsArray.length; ++i) {
            buff.append("[");
            buff.append(this._cellsArray[i]);
            buff.append("]");
        }
        return buff.toString();
    }

    private void calculateSummery(int indextToReplace, long counter) {
        if (this._lastSummery == -1L) {
            this._lastSummery = counter;
        } else if (!this._isArrayFull) {
            this._lastSummery += counter;
        } else {
            this._lastSummery -= this._cellsArray[indextToReplace];
            this._lastSummery += counter;
        }
    }

    private void calculateAverage() {
        if (!this._isArrayFull) {
            if (this._averagePeriod < this._cellsArraySize && this._lastUpdatedIndex >= this._averagePeriod) {
                this._lastAverage = this._lastSummery / (long)(this._lastUpdatedIndex + 1);
                this._lastAverage *= (long)this._averagePeriod;
            } else {
                this._lastAverage = this._lastSummery;
            }
        } else {
            this._lastAverage = this._cellsArraySize > 10 ? this._lastSummery : this._lastSummery / (long)this._cellsArraySize * (long)this._averagePeriod;
        }
    }

    public String getCurrentState() {
        StringBuffer buff = new StringBuffer();
        buff.append(this._myInfo);
        buff.append(" LastAverage = ");
        buff.append(this._lastAverage);
        buff.append(" LastSummery = ");
        buff.append(this._lastSummery);
        buff.append(" LastUpdatedIndex = ");
        buff.append(this._lastUpdatedIndex);
        buff.append(" \n\r Array: \n\r ");
        for (int i = 0; i < this._cellsArray.length; ++i) {
            buff.append(this._cellsArray[i]);
            buff.append(" , ");
        }
        return buff.toString();
    }
}

