/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.utility.tasks;

import com.ibm.ws.jbatch.utility.rest.WSPurgeResponse;
import com.ibm.ws.jbatch.utility.tasks.BaseBatchRestTask;
import com.ibm.ws.jbatch.utility.utils.ArgumentRequiredException;
import com.ibm.ws.jbatch.utility.utils.ConsoleWrapper;
import com.ibm.ws.jbatch.utility.utils.TaskIO;
import java.io.PrintStream;
import java.util.List;
import java.util.regex.Pattern;
import javax.batch.runtime.JobInstance;

public class PurgeTask
extends BaseBatchRestTask<PurgeTask> {
    public PurgeTask(String scriptName) {
        super("purge", scriptName);
    }

    @Override
    public int handleTask(ConsoleWrapper stdin, PrintStream stdout, PrintStream stderr, String[] args) throws Exception {
        this.setTaskIO(new TaskIO(stdin, stdout, stderr));
        this.setTaskArgs(args);
        if (this.getInstanceId() != null && !this.isNumeric(this.getInstanceId()) || this.getCreateTime() != null || this.getInstanceState() != null || this.getExitStatus() != null) {
            List<WSPurgeResponse> purgeResponseList = this.getBatchRestClient().purge(this.getPurgeJobStoreOnly(), this.getPage(), this.getPageSize(), this.getInstanceId(), this.getCreateTime(), this.getInstanceState(), this.getExitStatus());
            for (int i = 0; i < purgeResponseList.size(); ++i) {
                this.issueJobPurgedMessage(purgeResponseList.get(i));
            }
        } else if (this.getJobInstanceId() != -1L) {
            JobInstance jobInstance = this.getBatchRestClient().getJobInstance(this.getJobInstanceId());
            this.getBatchRestClient().purge(this.getJobInstanceId(), this.getPurgeJobStoreOnly());
            this.issueJobPurgedMessage(jobInstance);
        } else {
            throw new ArgumentRequiredException("Must specify at least one of --jobInstanceId, --createTime, --instanceState or --exitStatus");
        }
        return 0;
    }

    protected int getPage() {
        return this.getTaskArgs().getIntValue("--page", 0);
    }

    protected int getPageSize() {
        return this.getTaskArgs().getIntValue("--pageSize", 50);
    }

    protected String getCreateTime() {
        return this.getTaskArgs().getStringValue("--createTime");
    }

    protected String getInstanceState() {
        return this.getTaskArgs().getStringValue("--instanceState");
    }

    protected String getExitStatus() {
        return this.getTaskArgs().getStringValue("--exitStatus");
    }

    protected boolean getPurgeJobStoreOnly() {
        return this.getTaskArgs().isSpecified("--purgeJobStoreOnly");
    }

    protected String getInstanceId() {
        return this.getTaskArgs().getStringValue("--jobInstanceId");
    }

    protected Long getJobInstanceId() {
        return this.getTaskArgs().getLongValue("--jobInstanceId", -1L);
    }

    private boolean isNumeric(String s) {
        return Pattern.matches("\\d+", s);
    }
}

