/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jbatch.jms.internal.dispatcher;

import com.ibm.jbatch.container.ws.PartitionReplyMsg;
import com.ibm.jbatch.container.ws.PartitionReplyQueue;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.jbatch.jms.internal.BatchJmsMessage;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.batch.operations.BatchRuntimeException;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PartitionReplyQueueJms
implements PartitionReplyQueue {
    private Session jmsSession;
    private Connection jmsConn;
    private Destination jmsReplyToQueue;
    static final long serialVersionUID = 3033308559990406551L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public PartitionReplyQueueJms(Connection jmsConn) {
        this.jmsConn = jmsConn;
        try {
            this.jmsSession = this.jmsConn.createSession(false, 1);
            this.jmsReplyToQueue = this.jmsSession.createTemporaryQueue();
            jmsConn.start();
        }
        catch (JMSException jMSException) {
            void je;
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", (String)"60", (Object)this, (Object[])new Object[]{jmsConn});
            throw new BatchRuntimeException("Top-level thread for partitioned step could not open JMS session or create temporary reply-to queue", (Throwable)je);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PartitionReplyQueueJms(Connection jmsConn, Destination jmsReplyToQueue) {
        this.jmsConn = jmsConn;
        this.jmsReplyToQueue = jmsReplyToQueue;
        try {
            this.jmsSession = this.jmsConn.createSession(false, 1);
        }
        catch (JMSException jMSException) {
            void je;
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", (String)"78", (Object)this, (Object[])new Object[]{jmsConn, jmsReplyToQueue});
            throw new BatchRuntimeException("Sub-job partition thread could not open JMS session", (Throwable)je);
        }
    }

    public Session getSession() {
        return this.jmsSession;
    }

    public Destination getJmsReplyToQueue() {
        return this.jmsReplyToQueue;
    }

    /*
     * WARNING - void declaration
     */
    public boolean add(PartitionReplyMsg partitionReplyMsg) {
        try {
            MessageProducer messageProducer = this.getSession().createProducer(this.getJmsReplyToQueue());
            BatchJmsMessage jmsMsg = new BatchJmsMessage((Message)this.getSession().createObjectMessage()).setVersion().setPartitionReplyMsgPayload(partitionReplyMsg);
            messageProducer.send(jmsMsg.getMessage());
            return true;
        }
        catch (Exception messageProducer) {
            void je;
            FFDCFilter.processException((Throwable)messageProducer, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", (String)"120", (Object)this, (Object[])new Object[]{partitionReplyMsg});
            throw new BatchRuntimeException("Partition thread could not send data back to top-level thread over JMS reply-to queue", (Throwable)je);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PartitionReplyMsg take() {
        try {
            MessageConsumer jmsConsumer = this.jmsSession.createConsumer(this.getJmsReplyToQueue());
            ObjectMessage response = (ObjectMessage)jmsConsumer.receive(15000L);
            return response == null ? null : new BatchJmsMessage((Message)response).getPartitionReplyMsgPayload();
        }
        catch (Exception jmsConsumer) {
            void je;
            FFDCFilter.processException((Throwable)jmsConsumer, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", (String)"139", (Object)this, (Object[])new Object[0]);
            throw new BatchRuntimeException("Top-level thread for partitioned step could not receive msg from sub-job partitioned thread over JMS reply-to queue", (Throwable)je);
        }
    }

    /*
     * WARNING - void declaration
     */
    public PartitionReplyMsg takeWithoutWaiting() {
        try {
            MessageConsumer jmsConsumer = this.jmsSession.createConsumer(this.getJmsReplyToQueue());
            ObjectMessage response = (ObjectMessage)jmsConsumer.receiveNoWait();
            return response == null ? null : new BatchJmsMessage((Message)response).getPartitionReplyMsgPayload();
        }
        catch (Exception jmsConsumer) {
            void je;
            FFDCFilter.processException((Throwable)jmsConsumer, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", (String)"158", (Object)this, (Object[])new Object[0]);
            throw new BatchRuntimeException("Top-level thread for partitioned step could not receive msg from sub-job partitioned thread over JMS reply-to queue", (Throwable)je);
        }
    }

    public void close() {
        try {
            this.jmsConn.close();
        }
        catch (JMSException jMSException) {
            FFDCFilter.processException((Throwable)jMSException, (String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", (String)"173", (Object)this, (Object[])new Object[0]);
        }
    }

    public String toString() {
        return "PartitionReplyQueueJms:jmsConn=" + this.jmsConn + ",jmsReplyToQueue:" + this.jmsReplyToQueue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jbatch.jms.internal.dispatcher.PartitionReplyQueueJms", PartitionReplyQueueJms.class, (String)"wsbatch", null);
    }
}

