/*
 * Decompiled with CFR 0.152.
 */
package graphql.validation.rules;

import graphql.com.google.common.collect.Sets;
import graphql.language.ObjectField;
import graphql.language.ObjectValue;
import graphql.validation.AbstractRule;
import graphql.validation.ValidationContext;
import graphql.validation.ValidationErrorCollector;
import graphql.validation.ValidationErrorType;
import java.util.HashSet;

public class UniqueObjectFieldName
extends AbstractRule {
    public UniqueObjectFieldName(ValidationContext validationContext, ValidationErrorCollector validationErrorCollector) {
        super(validationContext, validationErrorCollector);
    }

    @Override
    public void checkObjectValue(ObjectValue objectValue) {
        HashSet<String> fieldNames = Sets.newHashSetWithExpectedSize(objectValue.getObjectFields().size());
        for (ObjectField field : objectValue.getObjectFields()) {
            String fieldName = field.getName();
            if (fieldNames.contains(fieldName)) {
                String message = this.i18n(ValidationErrorType.UniqueObjectFieldName, "UniqueObjectFieldName.duplicateFieldName", fieldName);
                this.addError(ValidationErrorType.UniqueObjectFieldName, objectValue.getSourceLocation(), message);
                continue;
            }
            fieldNames.add(fieldName);
        }
    }
}

