/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.nio.charset.UnsupportedCharsetException;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.Args;
import org.apache.http.util.ByteArrayBuffer;
import org.apache.http.util.CharArrayBuffer;

/*
 * Exception performing whole class analysis ignored.
 */
public final class EntityUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private EntityUtils() {
    }

    public static void consumeQuietly(HttpEntity entity) {
        try {
            EntityUtils.consume((HttpEntity)entity);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void consume(HttpEntity entity) throws IOException {
        InputStream inStream;
        if (entity == null) {
            return;
        }
        if (entity.isStreaming() && (inStream = entity.getContent()) != null) {
            inStream.close();
        }
    }

    public static void updateEntity(HttpResponse response, HttpEntity entity) throws IOException {
        Args.notNull((Object)response, (String)"Response");
        EntityUtils.consume((HttpEntity)response.getEntity());
        response.setEntity(entity);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toByteArray(HttpEntity entity) throws IOException {
        Args.notNull((Object)entity, (String)"Entity");
        InputStream inStream = entity.getContent();
        if (inStream == null) {
            return null;
        }
        try {
            int l;
            Args.check((entity.getContentLength() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity too large to be buffered in memory");
            int capacity = (int)entity.getContentLength();
            if (capacity < 0) {
                capacity = 4096;
            }
            ByteArrayBuffer buffer = new ByteArrayBuffer(capacity);
            byte[] tmp = new byte[4096];
            while ((l = inStream.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        finally {
            inStream.close();
        }
    }

    @Deprecated
    public static String getContentCharSet(HttpEntity entity) throws ParseException {
        NameValuePair param;
        HeaderElement[] values;
        Args.notNull((Object)entity, (String)"Entity");
        String charset = null;
        if (entity.getContentType() != null && (values = entity.getContentType().getElements()).length > 0 && (param = values[0].getParameterByName("charset")) != null) {
            charset = param.getValue();
        }
        return charset;
    }

    @Deprecated
    public static String getContentMimeType(HttpEntity entity) throws ParseException {
        HeaderElement[] values;
        Args.notNull((Object)entity, (String)"Entity");
        String mimeType = null;
        if (entity.getContentType() != null && (values = entity.getContentType().getElements()).length > 0) {
            mimeType = values[0].getName();
        }
        return mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(HttpEntity entity, ContentType contentType) throws IOException {
        InputStream inStream = entity.getContent();
        if (inStream == null) {
            return null;
        }
        try {
            int l;
            Args.check((entity.getContentLength() <= Integer.MAX_VALUE ? 1 : 0) != 0, (String)"HTTP entity too large to be buffered in memory");
            int capacity = (int)entity.getContentLength();
            if (capacity < 0) {
                capacity = 4096;
            }
            Charset charset = null;
            if (contentType != null && (charset = contentType.getCharset()) == null) {
                ContentType defaultContentType = ContentType.getByMimeType((String)contentType.getMimeType());
                Charset charset2 = charset = defaultContentType != null ? defaultContentType.getCharset() : null;
            }
            if (charset == null) {
                charset = HTTP.DEF_CONTENT_CHARSET;
            }
            InputStreamReader reader = new InputStreamReader(inStream, charset);
            CharArrayBuffer buffer = new CharArrayBuffer(capacity);
            char[] tmp = new char[1024];
            while ((l = reader.read(tmp)) != -1) {
                buffer.append(tmp, 0, l);
            }
            String string = buffer.toString();
            return string;
        }
        finally {
            inStream.close();
        }
    }

    public static String toString(HttpEntity entity, Charset defaultCharset) throws IOException, ParseException {
        ContentType contentType;
        block5: {
            Args.notNull((Object)entity, (String)"Entity");
            contentType = null;
            try {
                contentType = ContentType.get((HttpEntity)entity);
            }
            catch (UnsupportedCharsetException ex) {
                if (defaultCharset != null) break block5;
                throw new UnsupportedEncodingException(ex.getMessage());
            }
        }
        if (contentType != null) {
            if (contentType.getCharset() == null) {
                contentType = contentType.withCharset(defaultCharset);
            }
        } else {
            contentType = ContentType.DEFAULT_TEXT.withCharset(defaultCharset);
        }
        return EntityUtils.toString((HttpEntity)entity, (ContentType)contentType);
    }

    public static String toString(HttpEntity entity, String defaultCharset) throws IOException, ParseException {
        return EntityUtils.toString((HttpEntity)entity, (Charset)(defaultCharset != null ? Charset.forName(defaultCharset) : null));
    }

    public static String toString(HttpEntity entity) throws IOException, ParseException {
        Args.notNull((Object)entity, (String)"Entity");
        return EntityUtils.toString((HttpEntity)entity, (ContentType)ContentType.get((HttpEntity)entity));
    }
}

