/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import java.util.concurrent.Executor;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Contract;
import org.apache.http.annotation.ThreadingBehavior;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.NHttpClientHandler;
import org.apache.http.nio.NHttpConnection;
import org.apache.http.nio.entity.ContentBufferEntity;
import org.apache.http.nio.protocol.HttpRequestExecutionHandler;
import org.apache.http.nio.protocol.NHttpHandlerBase;
import org.apache.http.nio.protocol.ThrottlingHttpClientHandler;
import org.apache.http.nio.util.ByteBufferAllocator;
import org.apache.http.nio.util.ContentInputBuffer;
import org.apache.http.nio.util.ContentOutputBuffer;
import org.apache.http.nio.util.DirectByteBufferAllocator;
import org.apache.http.params.DefaultedHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;

@Deprecated
@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
public class ThrottlingHttpClientHandler
extends NHttpHandlerBase
implements NHttpClientHandler {
    protected HttpRequestExecutionHandler execHandler;
    protected final Executor executor;
    private final int bufsize;

    public ThrottlingHttpClientHandler(HttpProcessor httpProcessor, HttpRequestExecutionHandler execHandler, ConnectionReuseStrategy connStrategy, ByteBufferAllocator allocator, Executor executor, HttpParams params) {
        super(httpProcessor, connStrategy, allocator, params);
        Args.notNull((Object)execHandler, (String)"HTTP request execution handler");
        Args.notNull((Object)executor, (String)"Executor");
        this.execHandler = execHandler;
        this.executor = executor;
        this.bufsize = this.params.getIntParameter("http.nio.content-buffer-size", 20480);
    }

    public ThrottlingHttpClientHandler(HttpProcessor httpProcessor, HttpRequestExecutionHandler execHandler, ConnectionReuseStrategy connStrategy, Executor executor, HttpParams params) {
        this(httpProcessor, execHandler, connStrategy, (ByteBufferAllocator)DirectByteBufferAllocator.INSTANCE, executor, params);
    }

    public void connected(NHttpClientConnection conn, Object attachment) {
        HttpContext context = conn.getContext();
        this.initialize(conn, attachment);
        ClientConnState connState = new ClientConnState(this.bufsize, (IOControl)conn, this.allocator);
        context.setAttribute("http.nio.conn-state", (Object)connState);
        if (this.eventListener != null) {
            this.eventListener.connectionOpen((NHttpConnection)conn);
        }
        this.requestReady(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closed(NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
        if (connState != null) {
            ClientConnState clientConnState = connState;
            synchronized (clientConnState) {
                connState.close();
                connState.notifyAll();
            }
        }
        this.execHandler.finalizeContext(context);
        if (this.eventListener != null) {
            this.eventListener.connectionClosed((NHttpConnection)conn);
        }
    }

    public void exception(NHttpClientConnection conn, HttpException ex) {
        this.closeConnection((NHttpConnection)conn, (Throwable)ex);
        if (this.eventListener != null) {
            this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
        }
    }

    public void exception(NHttpClientConnection conn, IOException ex) {
        this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
        if (this.eventListener != null) {
            this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestReady(NHttpClientConnection conn) {
        block12: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState = connState;
                synchronized (clientConnState) {
                    if (connState.getOutputState() != 0) {
                        return;
                    }
                    HttpRequest request = this.execHandler.submitRequest(context);
                    if (request == null) {
                        return;
                    }
                    request.setParams((HttpParams)new DefaultedHttpParams(request.getParams(), this.params));
                    context.setAttribute("http.request", (Object)request);
                    this.httpProcessor.process(request, context);
                    connState.setRequest(request);
                    conn.submitRequest(request);
                    connState.setOutputState(1);
                    conn.requestInput();
                    if (request instanceof HttpEntityEnclosingRequest) {
                        if (((HttpEntityEnclosingRequest)request).expectContinue()) {
                            int timeout = conn.getSocketTimeout();
                            connState.setTimeout(timeout);
                            timeout = this.params.getIntParameter("http.protocol.wait-for-continue", 3000);
                            conn.setSocketTimeout(timeout);
                            connState.setOutputState(2);
                        } else {
                            this.sendRequestBody((HttpEntityEnclosingRequest)request, connState, conn);
                        }
                    }
                    connState.notifyAll();
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block12;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void outputReady(NHttpClientConnection conn, ContentEncoder encoder) {
        block8: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState = connState;
                synchronized (clientConnState) {
                    if (connState.getOutputState() == 2) {
                        conn.suspendOutput();
                        return;
                    }
                    ContentOutputBuffer buffer = connState.getOutbuffer();
                    buffer.produceContent(encoder);
                    if (encoder.isCompleted()) {
                        connState.setInputState(8);
                    } else {
                        connState.setInputState(4);
                    }
                    connState.notifyAll();
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseReceived(NHttpClientConnection conn) {
        block13: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState = connState;
                synchronized (clientConnState) {
                    HttpResponse response = conn.getHttpResponse();
                    response.setParams((HttpParams)new DefaultedHttpParams(response.getParams(), this.params));
                    HttpRequest request = connState.getRequest();
                    int statusCode = response.getStatusLine().getStatusCode();
                    if (statusCode < 200) {
                        if (statusCode == 100 && connState.getOutputState() == 2) {
                            connState.setOutputState(1);
                            this.continueRequest(conn, connState);
                        }
                        return;
                    }
                    connState.setResponse(response);
                    connState.setInputState(16);
                    if (connState.getOutputState() == 2) {
                        int timeout = connState.getTimeout();
                        conn.setSocketTimeout(timeout);
                        conn.resetOutput();
                    }
                    if (!this.canResponseHaveBody(request, response)) {
                        conn.resetInput();
                        response.setEntity(null);
                        connState.setInputState(64);
                        if (!this.connStrategy.keepAlive(response, context)) {
                            conn.close();
                        }
                    }
                    if (response.getEntity() != null) {
                        response.setEntity((HttpEntity)new ContentBufferEntity(response.getEntity(), connState.getInbuffer()));
                    }
                    context.setAttribute("http.response", (Object)response);
                    this.httpProcessor.process(response, context);
                    this.handleResponse(response, connState, conn);
                    connState.notifyAll();
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener != null) {
                    this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
                }
            }
            catch (HttpException ex) {
                this.closeConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block13;
                this.eventListener.fatalProtocolException(ex, (NHttpConnection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void inputReady(NHttpClientConnection conn, ContentDecoder decoder) {
        block8: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState = connState;
                synchronized (clientConnState) {
                    HttpResponse response = connState.getResponse();
                    ContentInputBuffer buffer = connState.getInbuffer();
                    buffer.consumeContent(decoder);
                    if (decoder.isCompleted()) {
                        connState.setInputState(64);
                        if (!this.connStrategy.keepAlive(response, context)) {
                            conn.close();
                        }
                    } else {
                        connState.setInputState(32);
                    }
                    connState.notifyAll();
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block8;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void timeout(NHttpClientConnection conn) {
        block6: {
            HttpContext context = conn.getContext();
            ClientConnState connState = (ClientConnState)context.getAttribute("http.nio.conn-state");
            try {
                ClientConnState clientConnState = connState;
                synchronized (clientConnState) {
                    if (connState.getOutputState() == 2) {
                        connState.setOutputState(1);
                        this.continueRequest(conn, connState);
                        connState.notifyAll();
                        return;
                    }
                }
            }
            catch (IOException ex) {
                this.shutdownConnection((NHttpConnection)conn, (Throwable)ex);
                if (this.eventListener == null) break block6;
                this.eventListener.fatalIOException(ex, (NHttpConnection)conn);
            }
        }
        this.handleTimeout((NHttpConnection)conn);
    }

    private void initialize(NHttpClientConnection conn, Object attachment) {
        HttpContext context = conn.getContext();
        context.setAttribute("http.connection", (Object)conn);
        this.execHandler.initalizeContext(context, attachment);
    }

    private void continueRequest(NHttpClientConnection conn, ClientConnState connState) throws IOException {
        HttpRequest request = connState.getRequest();
        int timeout = connState.getTimeout();
        conn.setSocketTimeout(timeout);
        this.sendRequestBody((HttpEntityEnclosingRequest)request, connState, conn);
    }

    private void sendRequestBody(HttpEntityEnclosingRequest request, ClientConnState connState, NHttpClientConnection conn) throws IOException {
        HttpEntity entity = request.getEntity();
        if (entity != null) {
            this.executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
        }
    }

    private void handleResponse(HttpResponse response, ClientConnState connState, NHttpClientConnection conn) {
        HttpContext context = conn.getContext();
        this.executor.execute((Runnable)new /* Unavailable Anonymous Inner Class!! */);
    }
}

