/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.http.ConnectionClosedException;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.concurrent.BasicFuture;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.nio.ContentDecoder;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.NHttpClientConnection;
import org.apache.http.nio.protocol.HttpAsyncClientExchangeHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.nio.protocol.HttpAsyncResponseConsumer;
import org.apache.http.nio.protocol.Pipelined;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

/*
 * Exception performing whole class analysis ignored.
 */
@Pipelined
public class PipeliningClientExchangeHandler<T>
implements HttpAsyncClientExchangeHandler {
    private final Queue<HttpAsyncRequestProducer> requestProducerQueue;
    private final Queue<HttpAsyncResponseConsumer<T>> responseConsumerQueue;
    private final Queue<HttpRequest> requestQueue;
    private final Queue<T> resultQueue;
    private final BasicFuture<List<T>> future;
    private final HttpContext localContext;
    private final NHttpClientConnection conn;
    private final HttpProcessor httpPocessor;
    private final ConnectionReuseStrategy connReuseStrategy;
    private final AtomicReference<HttpAsyncRequestProducer> requestProducerRef;
    private final AtomicReference<HttpAsyncResponseConsumer<T>> responseConsumerRef;
    private final AtomicBoolean keepAlive;
    private final AtomicBoolean closed;

    public PipeliningClientExchangeHandler(List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, FutureCallback<List<T>> callback, HttpContext localContext, NHttpClientConnection conn, HttpProcessor httpPocessor, ConnectionReuseStrategy connReuseStrategy) {
        Args.notEmpty(requestProducers, (String)"Request producer list");
        Args.notEmpty(responseConsumers, (String)"Response consumer list");
        Args.check((requestProducers.size() == responseConsumers.size() ? 1 : 0) != 0, (String)"Number of request producers does not match that of response consumers");
        this.requestProducerQueue = new ConcurrentLinkedQueue<HttpAsyncRequestProducer>(requestProducers);
        this.responseConsumerQueue = new ConcurrentLinkedQueue<HttpAsyncResponseConsumer<T>>(responseConsumers);
        this.requestQueue = new ConcurrentLinkedQueue();
        this.resultQueue = new ConcurrentLinkedQueue();
        this.future = new BasicFuture(callback);
        this.localContext = (HttpContext)Args.notNull((Object)localContext, (String)"HTTP context");
        this.conn = (NHttpClientConnection)Args.notNull((Object)conn, (String)"HTTP connection");
        this.httpPocessor = (HttpProcessor)Args.notNull((Object)httpPocessor, (String)"HTTP processor");
        this.connReuseStrategy = connReuseStrategy != null ? connReuseStrategy : DefaultConnectionReuseStrategy.INSTANCE;
        this.localContext.setAttribute("http.connection", (Object)this.conn);
        this.requestProducerRef = new AtomicReference<Object>(null);
        this.responseConsumerRef = new AtomicReference<Object>(null);
        this.keepAlive = new AtomicBoolean(false);
        this.closed = new AtomicBoolean(false);
    }

    public PipeliningClientExchangeHandler(List<? extends HttpAsyncRequestProducer> requestProducers, List<? extends HttpAsyncResponseConsumer<T>> responseConsumers, HttpContext localContext, NHttpClientConnection conn, HttpProcessor httpPocessor) {
        this(requestProducers, responseConsumers, null, localContext, conn, httpPocessor, null);
    }

    public Future<List<T>> getFuture() {
        return this.future;
    }

    private static void closeQuietly(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private void releaseResources() {
        PipeliningClientExchangeHandler.closeQuietly((Closeable)this.requestProducerRef.getAndSet(null));
        PipeliningClientExchangeHandler.closeQuietly((Closeable)this.responseConsumerRef.getAndSet(null));
        while (!this.requestProducerQueue.isEmpty()) {
            PipeliningClientExchangeHandler.closeQuietly((Closeable)((Closeable)this.requestProducerQueue.remove()));
        }
        while (!this.responseConsumerQueue.isEmpty()) {
            PipeliningClientExchangeHandler.closeQuietly((Closeable)((Closeable)this.responseConsumerQueue.remove()));
        }
        this.requestQueue.clear();
        this.resultQueue.clear();
    }

    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.releaseResources();
            if (!this.future.isDone()) {
                this.future.cancel();
            }
        }
    }

    public HttpRequest generateRequest() throws IOException, HttpException {
        Asserts.check((this.requestProducerRef.get() == null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is not null");
        HttpAsyncRequestProducer requestProducer = (HttpAsyncRequestProducer)this.requestProducerQueue.poll();
        if (requestProducer == null) {
            return null;
        }
        this.requestProducerRef.set(requestProducer);
        HttpRequest request = requestProducer.generateRequest();
        this.httpPocessor.process(request, this.localContext);
        this.requestQueue.add(request);
        return request;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        HttpAsyncRequestProducer requestProducer = (HttpAsyncRequestProducer)this.requestProducerRef.get();
        Asserts.check((requestProducer != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        requestProducer.produceContent(encoder, ioControl);
    }

    public void requestCompleted() {
        HttpAsyncRequestProducer requestProducer = this.requestProducerRef.getAndSet(null);
        Asserts.check((requestProducer != null ? 1 : 0) != 0, (String)"Inconsistent state: request producer is null");
        requestProducer.requestCompleted(this.localContext);
    }

    public void responseReceived(HttpResponse response) throws IOException, HttpException {
        Asserts.check((this.responseConsumerRef.get() == null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is not null");
        HttpAsyncResponseConsumer responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerQueue.poll();
        Asserts.check((responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer queue is empty");
        this.responseConsumerRef.set(responseConsumer);
        HttpRequest request = (HttpRequest)this.requestQueue.poll();
        Asserts.check((request != null ? 1 : 0) != 0, (String)"Inconsistent state: request queue is empty");
        this.localContext.setAttribute("http.request", (Object)request);
        this.localContext.setAttribute("http.response", (Object)response);
        this.httpPocessor.process(response, this.localContext);
        responseConsumer.responseReceived(response);
        this.keepAlive.set(this.connReuseStrategy.keepAlive(response, this.localContext));
    }

    public void consumeContent(ContentDecoder decoder, IOControl ioControl) throws IOException {
        HttpAsyncResponseConsumer responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerRef.get();
        Asserts.check((responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        responseConsumer.consumeContent(decoder, ioControl);
    }

    public void responseCompleted() throws IOException {
        HttpAsyncResponseConsumer responseConsumer = this.responseConsumerRef.getAndSet(null);
        Asserts.check((responseConsumer != null ? 1 : 0) != 0, (String)"Inconsistent state: response consumer is null");
        try {
            if (!this.keepAlive.get()) {
                this.conn.close();
            }
            responseConsumer.responseCompleted(this.localContext);
            Object result = responseConsumer.getResult();
            Exception ex = responseConsumer.getException();
            if (result != null) {
                this.resultQueue.add(result);
            } else {
                this.future.failed(ex);
                this.conn.shutdown();
            }
            if (!this.conn.isOpen() && this.closed.compareAndSet(false, true)) {
                this.releaseResources();
            }
            if (!this.future.isDone() && this.responseConsumerQueue.isEmpty()) {
                this.future.completed(new ArrayList(this.resultQueue));
                this.resultQueue.clear();
            }
        }
        catch (RuntimeException ex) {
            this.failed((Exception)ex);
            throw ex;
        }
    }

    public void inputTerminated() {
        this.failed((Exception)new ConnectionClosedException());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failed(Exception ex) {
        if (this.closed.compareAndSet(false, true)) {
            try {
                HttpAsyncResponseConsumer responseConsumer;
                HttpAsyncRequestProducer requestProducer = (HttpAsyncRequestProducer)this.requestProducerRef.get();
                if (requestProducer != null) {
                    requestProducer.failed(ex);
                }
                if ((responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerRef.get()) != null) {
                    responseConsumer.failed(ex);
                }
            }
            finally {
                try {
                    this.future.failed(ex);
                }
                finally {
                    this.releaseResources();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel() {
        if (this.closed.compareAndSet(false, true)) {
            try {
                boolean bl;
                try {
                    HttpAsyncResponseConsumer responseConsumer = (HttpAsyncResponseConsumer)this.responseConsumerRef.get();
                    bl = responseConsumer != null && responseConsumer.cancel();
                }
                catch (Throwable throwable) {
                    this.future.cancel();
                    throw throwable;
                }
                this.future.cancel();
                return bl;
            }
            finally {
                this.releaseResources();
            }
        }
        return false;
    }

    public boolean isDone() {
        return this.future.isDone();
    }
}

