/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.nio.protocol;

import java.io.IOException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.nio.ContentEncoder;
import org.apache.http.nio.IOControl;
import org.apache.http.nio.entity.EntityAsyncContentProducer;
import org.apache.http.nio.entity.HttpAsyncContentProducer;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

public class BasicAsyncRequestProducer
implements HttpAsyncRequestProducer {
    private final HttpHost target;
    private final HttpRequest request;
    private final HttpAsyncContentProducer producer;

    protected BasicAsyncRequestProducer(HttpHost target, HttpEntityEnclosingRequest request, HttpAsyncContentProducer producer) {
        Args.notNull((Object)target, (String)"HTTP host");
        Args.notNull((Object)request, (String)"HTTP request");
        Args.notNull((Object)producer, (String)"HTTP content producer");
        this.target = target;
        this.request = request;
        this.producer = producer;
    }

    public BasicAsyncRequestProducer(HttpHost target, HttpRequest request) {
        HttpEntity entity;
        Args.notNull((Object)target, (String)"HTTP host");
        Args.notNull((Object)request, (String)"HTTP request");
        this.target = target;
        this.request = request;
        this.producer = request instanceof HttpEntityEnclosingRequest ? ((entity = ((HttpEntityEnclosingRequest)request).getEntity()) != null ? (entity instanceof HttpAsyncContentProducer ? (HttpAsyncContentProducer)entity : new EntityAsyncContentProducer(entity)) : null) : null;
    }

    public HttpRequest generateRequest() {
        return this.request;
    }

    public HttpHost getTarget() {
        return this.target;
    }

    public void produceContent(ContentEncoder encoder, IOControl ioControl) throws IOException {
        if (this.producer != null) {
            this.producer.produceContent(encoder, ioControl);
            if (encoder.isCompleted()) {
                this.producer.close();
            }
        }
    }

    public void requestCompleted(HttpContext context) {
    }

    public void failed(Exception ex) {
    }

    public boolean isRepeatable() {
        return this.producer == null || this.producer.isRepeatable();
    }

    public void resetRequest() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public void close() throws IOException {
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.target);
        sb.append(' ');
        sb.append(this.request);
        if (this.producer != null) {
            sb.append(' ');
            sb.append(this.producer);
        }
        return sb.toString();
    }
}

