/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.objectstore.hornetq;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.objectstore.ObjectStoreAPI;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqJournalEnvironmentBean;
import com.arjuna.ats.internal.arjuna.objectstore.hornetq.HornetqJournalStore;
import com.arjuna.common.internal.util.propertyservice.BeanPopulator;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.HashSet;

public class HornetqObjectStoreAdaptor
implements ObjectStoreAPI {
    private final HornetqJournalStore store;

    public HornetqObjectStoreAdaptor() throws IOException {
        HornetqJournalEnvironmentBean envBean = (HornetqJournalEnvironmentBean)BeanPopulator.getDefaultInstance(HornetqJournalEnvironmentBean.class);
        this.store = new HornetqJournalStore(envBean);
    }

    public HornetqObjectStoreAdaptor(HornetqJournalEnvironmentBean envBean) throws IOException {
        this.store = new HornetqJournalStore(envBean);
    }

    public HornetqObjectStoreAdaptor(HornetqJournalStore store) {
        this.store = store;
    }

    public void start() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"HornetqObjectStore.start()");
        }
        try {
            this.store.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"HornetqObjectStore.stop()");
        }
        try {
            this.store.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public InputObjectState read_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    public boolean remove_uncommitted(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    private String ensureTypenamePrefix(String typeName) {
        if (!typeName.startsWith("/")) {
            typeName = "/" + typeName;
        }
        return typeName;
    }

    public InputObjectState read_committed(Uid u, String typeName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HornetqObjectStore.read_committed(" + u + ", " + typeName + ")"));
        }
        typeName = this.ensureTypenamePrefix(typeName);
        return this.store.read_committed(u, typeName);
    }

    public boolean remove_committed(Uid u, String typeName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HornetqObjectStore.remove_committed(" + u + ", " + typeName + ")"));
        }
        typeName = this.ensureTypenamePrefix(typeName);
        return this.store.remove_committed(u, typeName);
    }

    public boolean hide_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    public boolean reveal_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    public boolean commit_state(Uid u, String tn) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    public int currentState(Uid u, String typeName) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HornetqObjectStore.currentState(" + u + ", " + typeName + ")"));
        }
        if (this.store.contains(u, typeName = this.ensureTypenamePrefix(typeName))) {
            return 1;
        }
        return -1;
    }

    public boolean write_uncommitted(Uid u, String tn, OutputObjectState buff) throws ObjectStoreException {
        throw new ObjectStoreException(tsLogger.i18NLogger.get_method_not_implemented());
    }

    public boolean write_committed(Uid u, String typeName, OutputObjectState buff) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HornetqObjectStore.write_committed(" + u + ", " + typeName + ")"));
        }
        typeName = this.ensureTypenamePrefix(typeName);
        return this.store.write_committed(u, typeName, buff);
    }

    public boolean allObjUids(String typeName, InputObjectState foundInstances) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HornetqObjectStore.allObjUids(" + typeName + ")"));
        }
        typeName = this.ensureTypenamePrefix(typeName);
        return this.allObjUids(typeName, foundInstances, -1);
    }

    public boolean allObjUids(String typeName, InputObjectState foundInstances, int matchState) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("HornetqObjectStore.allObjUids(" + typeName + ", " + matchState + ")"));
        }
        boolean result = true;
        typeName = this.ensureTypenamePrefix(typeName);
        Uid[] uids = this.store.getUidsForType(typeName);
        OutputObjectState buffer = new OutputObjectState();
        try {
            if (uids != null && (matchState == -1 || matchState == 1)) {
                for (Uid uid : uids) {
                    if (uid == null) continue;
                    UidHelper.packInto((Uid)uid, (OutputBuffer)buffer);
                }
            }
            UidHelper.packInto((Uid)Uid.nullUid(), (OutputBuffer)buffer);
        }
        catch (IOException e) {
            throw new ObjectStoreException((Throwable)e);
        }
        foundInstances.setBuffer(buffer.buffer());
        return result;
    }

    public boolean allTypes(InputObjectState foundTypes) throws ObjectStoreException {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"HornetqObjectStore.allTypes()");
        }
        boolean result = true;
        String[] knownTypes = this.store.getKnownTypes();
        HashSet<String> typeSet = new HashSet<String>();
        if (knownTypes == null || knownTypes.length == 0) {
            return true;
        }
        OutputObjectState buffer = new OutputObjectState();
        try {
            for (String typeName : knownTypes) {
                if (typeName == null) continue;
                if (typeName.startsWith("/")) {
                    typeName = typeName.substring(1);
                }
                if (typeName.contains("/")) {
                    String[] parents;
                    String value = "";
                    for (String parent : parents = typeName.split("/")) {
                        if (parent.length() == 0) continue;
                        if (value.length() > 0) {
                            value = value + "/";
                        }
                        if (typeSet.contains(value = value + parent)) continue;
                        typeSet.add(value);
                        buffer.packString(value);
                    }
                    continue;
                }
                buffer.packString(typeName);
            }
            buffer.packString("");
        }
        catch (IOException e) {
            throw new ObjectStoreException((Throwable)e);
        }
        foundTypes.setBuffer(buffer.buffer());
        return result;
    }

    public void sync() throws SyncFailedException, ObjectStoreException {
    }

    public String getStoreName() {
        return this.store.getStoreName();
    }

    public boolean fullCommitNeeded() {
        return false;
    }

    public boolean isType(Uid u, String tn, int st) throws ObjectStoreException {
        return false;
    }
}

