/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.StateManager;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.RecordType;
import com.arjuna.ats.arjuna.logging.tsLogger;
import com.arjuna.ats.arjuna.state.InputBuffer;
import com.arjuna.ats.arjuna.state.InputObjectState;
import com.arjuna.ats.arjuna.state.OutputBuffer;
import com.arjuna.ats.arjuna.state.OutputObjectState;
import com.arjuna.ats.internal.arjuna.common.UidHelper;
import java.io.IOException;
import java.io.PrintWriter;

public abstract class AbstractRecord
extends StateManager {
    private AbstractRecord next = null;
    private AbstractRecord previous = null;
    private Uid uidOfObject;
    private String typeOfObject;
    private static final boolean useAlternativeOrdering = arjPropertyManager.getCoordinatorEnvironmentBean().isAlternativeRecordOrdering();

    public abstract int typeIs();

    public abstract Object value();

    public abstract void setValue(Object var1);

    public abstract int nestedAbort();

    public abstract int nestedCommit();

    public abstract int nestedPrepare();

    public abstract int topLevelAbort();

    public abstract int topLevelCommit();

    public abstract int topLevelPrepare();

    public Uid order() {
        return this.uidOfObject;
    }

    public String getTypeOfObject() {
        return this.typeOfObject;
    }

    public boolean propagateOnAbort() {
        return false;
    }

    public boolean propagateOnCommit() {
        return true;
    }

    public final boolean equals(AbstractRecord ar) {
        return useAlternativeOrdering ? this.typeEquals(ar) : this.orderEquals(ar);
    }

    public final boolean lessThan(AbstractRecord ar) {
        return useAlternativeOrdering ? this.typeLessThan(ar) : this.orderLessThan(ar);
    }

    public final boolean greaterThan(AbstractRecord ar) {
        return useAlternativeOrdering ? this.typeGreaterThan(ar) : this.orderGreaterThan(ar);
    }

    public int topLevelCleanup() {
        return this.topLevelAbort();
    }

    public int nestedCleanup() {
        return this.nestedAbort();
    }

    public boolean doSave() {
        return false;
    }

    public String type() {
        return "/StateManager/AbstractRecord";
    }

    public void print(PrintWriter strm) {
        strm.println("Uid of Managed Object: " + this.uidOfObject);
        strm.println("Type of Managed Object: " + this.typeOfObject);
        super.print(strm);
    }

    public boolean save_state(OutputObjectState os, int i) {
        try {
            UidHelper.packInto((Uid)this.uidOfObject, (OutputBuffer)os);
            os.packString(this.typeOfObject);
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean restore_state(InputObjectState os, int i) {
        this.typeOfObject = null;
        try {
            this.uidOfObject = UidHelper.unpackFrom((InputBuffer)os);
            this.typeOfObject = os.unpackString();
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean forgetHeuristic() {
        return true;
    }

    public void clearHeuristicDecision() {
    }

    public int nestedOnePhaseCommit() {
        int res = this.nestedPrepare();
        switch (res) {
            case 0: {
                return this.nestedCommit();
            }
            case 2: {
                return 7;
            }
        }
        return 8;
    }

    public boolean isPermittedTopLevelOnePhaseCommit() {
        return true;
    }

    public int topLevelOnePhaseCommit() {
        int res = this.topLevelPrepare();
        switch (res) {
            case 0: {
                return this.topLevelCommit();
            }
            case 2: {
                return 7;
            }
            case 10: {
                return 10;
            }
        }
        return 8;
    }

    public static AbstractRecord create(int type) {
        try {
            Class recordClass = RecordType.typeToClass((int)type);
            return (AbstractRecord)recordClass.newInstance();
        }
        catch (NullPointerException ex) {
            tsLogger.i18NLogger.warn_coordinator_AbstractRecord_npe(Integer.toString(type));
            return null;
        }
        catch (Throwable ex) {
            Class rt = RecordType.typeToClass((int)type);
            String className = rt == null ? "null" : rt.getName();
            tsLogger.i18NLogger.warn_coordinator_AbstractRecord_create_failure(Integer.valueOf(type), className);
            ex.printStackTrace();
            return null;
        }
    }

    public abstract void merge(AbstractRecord var1);

    public abstract void alter(AbstractRecord var1);

    public abstract boolean shouldAdd(AbstractRecord var1);

    public abstract boolean shouldAlter(AbstractRecord var1);

    public abstract boolean shouldMerge(AbstractRecord var1);

    public abstract boolean shouldReplace(AbstractRecord var1);

    public void replace(AbstractRecord a) {
    }

    protected final AbstractRecord getPrevious() {
        return this.previous;
    }

    protected final AbstractRecord getNext() {
        return this.next;
    }

    protected final void setPrevious(AbstractRecord ar) {
        this.previous = ar;
    }

    protected final void setNext(AbstractRecord ar) {
        this.next = ar;
    }

    protected AbstractRecord(Uid storeUid, String objType, int otype) {
        super(otype);
        this.uidOfObject = storeUid;
        this.typeOfObject = objType;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("AbstractRecord::AbstractRecord (" + storeUid + ", " + otype + ")"));
        }
    }

    protected AbstractRecord(Uid storeUid) {
        super(storeUid);
        this.uidOfObject = storeUid;
        this.typeOfObject = null;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("AbstractRecord::AbstractRecord (" + storeUid + ")"));
        }
    }

    public AbstractRecord() {
        super(Uid.nullUid());
        this.uidOfObject = new Uid(Uid.nullUid());
        this.typeOfObject = null;
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"AbstractRecord::AbstractRecord () - crash recovery constructor");
        }
    }

    private final boolean typeEquals(AbstractRecord ar) {
        return this.typeIs() == ar.typeIs() && this.order().equals(ar.order());
    }

    private final boolean typeLessThan(AbstractRecord ar) {
        return this.typeIs() < ar.typeIs() || this.typeIs() == ar.typeIs() && this.order().lessThan(ar.order());
    }

    private final boolean typeGreaterThan(AbstractRecord ar) {
        return this.typeIs() > ar.typeIs() || this.typeIs() == ar.typeIs() && this.order().greaterThan(ar.order());
    }

    private final boolean orderEquals(AbstractRecord ar) {
        return this.order().equals(ar.order()) && this.typeIs() == ar.typeIs();
    }

    private final boolean orderLessThan(AbstractRecord ar) {
        return this.order().lessThan(ar.order()) || this.order().equals(ar.order()) && this.typeIs() < ar.typeIs();
    }

    private final boolean orderGreaterThan(AbstractRecord ar) {
        return this.order().greaterThan(ar.order()) || this.order().equals(ar.order()) && this.typeIs() > ar.typeIs();
    }
}

