/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.sso20.acs;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.saml.Constants;
import com.ibm.ws.security.saml.SsoHandler;
import com.ibm.ws.security.saml.SsoRequest;
import com.ibm.ws.security.saml.SsoSamlService;
import com.ibm.ws.security.saml.error.SamlException;
import com.ibm.ws.security.saml.sso20.acs.SolicitedHandler;
import com.ibm.ws.security.saml.sso20.acs.UnsolicitedHandler;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.Map;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AcsHandler
implements SsoHandler {
    private static TraceComponent tc = Tr.register(AcsHandler.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    static final long serialVersionUID = -1250145839397109437L;

    @Override
    public Constants.SamlSsoVersion getSamlVersion() {
        return Constants.SamlSsoVersion.SAMLSSO20;
    }

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Map<String, Object> parameters) throws SamlException {
        SolicitedHandler solicitedHandler = new SolicitedHandler(request, response, samlRequest, parameters);
        UnsolicitedHandler unsolicitedHandler = new UnsolicitedHandler(request, response, samlRequest, parameters);
        this.handleRequest(request, response, samlRequest, parameters, solicitedHandler, unsolicitedHandler);
    }

    public void handleRequest(HttpServletRequest request, HttpServletResponse response, SsoRequest samlRequest, Map<String, Object> parameters, SolicitedHandler solicitedHandler, UnsolicitedHandler unsolicitedHandler) throws SamlException {
        String externalRrelayState;
        SsoSamlService ssoService = (SsoSamlService)parameters.get(Constants.KEY_SAML_SERVICE);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SAML WEBSSO - handleRequest(ACS): providerId:" + ssoService.getProviderId() + " request:" + request + " response:" + response + " Request:" + samlRequest + " Service:" + ssoService), (Object[])new Object[0]);
        }
        if ((externalRrelayState = request.getParameter("RelayState")) != null && !externalRrelayState.isEmpty() && externalRrelayState.startsWith("sp_initial_")) {
            solicitedHandler.handleRequest(externalRrelayState);
        } else {
            boolean createSession;
            if (ssoService.getConfig() != null && (createSession = ssoService.getConfig().createSession())) {
                try {
                    request.getSession(true);
                }
                catch (Exception exception) {
                    FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.saml.sso20.acs.AcsHandler", (String)"96", (Object)this, (Object[])new Object[]{request, response, samlRequest, parameters, solicitedHandler, unsolicitedHandler});
                }
            }
            unsolicitedHandler.handleRequest(externalRrelayState);
        }
    }
}

