/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.KeyException;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.ws.security.common.jwk.impl.JwkKidBuilder;
import com.ibm.ws.security.jwt.config.JwtConfig;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import com.ibm.ws.security.jwt.internal.BuilderImpl;
import com.ibm.ws.security.jwt.internal.JwtTokenException;
import com.ibm.ws.security.jwt.utils.JwtData;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import java.security.Key;
import java.security.KeyStoreException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jose4j.base64url.Base64;
import org.jose4j.jwe.JsonWebEncryption;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.lang.JoseException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JweHelper {
    private static final TraceComponent tc = Tr.register(JweHelper.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private static final String NOT_PERIOD = "[^\\.]";
    private static final Pattern JWS_PATTERN = Pattern.compile("^([^\\.]*\\.){2}[^\\.]*$");
    private static final Pattern JWE_PATTERN = Pattern.compile("^([^\\.]*\\.){4}[^\\.]*$");
    static final long serialVersionUID = 5370398027880915039L;

    @FFDCIgnore(value={Exception.class})
    public static String createJweString(String jws, JwtData jwtData) throws Exception {
        JwtConfig jwtConfig = jwtData.getConfig();
        try {
            JsonWebEncryption jwe = new JsonWebEncryption();
            BuilderImpl builder = jwtData.getBuilder();
            JweHelper.setJweKeyData(jwe, builder, jwtConfig);
            JweHelper.setJweHeaders(jwe, builder, jwtConfig);
            jwe.setPayload(jws);
            return JweHelper.getJwtString(jwe);
        }
        catch (Exception e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_BUILDING_SIGNED_JWE", (Object[])new Object[]{jwtConfig.getId(), e});
            throw new Exception(errorMsg, e);
        }
    }

    public static boolean isJws(String jwtString) {
        if (jwtString == null || jwtString.isEmpty()) {
            return false;
        }
        Matcher m = JWS_PATTERN.matcher(jwtString);
        return m.matches();
    }

    public static boolean isJwe(String jwtString) {
        if (jwtString == null || jwtString.isEmpty()) {
            return false;
        }
        Matcher m = JWE_PATTERN.matcher(jwtString);
        return m.matches();
    }

    public static boolean isJwsRequired(JwtConsumerConfig config) {
        return !JweHelper.isJweRequired(config);
    }

    public static boolean isJwsRequired(JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        return !JweHelper.isJweRequired(config, mpConfigProps);
    }

    public static boolean isJweRequired(JwtConsumerConfig config) {
        String keyAlias = config.getKeyManagementKeyAlias();
        return keyAlias != null;
    }

    public static boolean isJweRequired(JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        String keyAlias = config.getKeyManagementKeyAlias();
        String keyLocation = (String)mpConfigProps.get("mp.jwt.decrypt.key.location");
        return keyAlias != null || keyLocation != null;
    }

    public static String extractJwsFromJweToken(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws InvalidTokenException {
        JwtClaims jweHeaderParameters = JweHelper.getJweHeaderParams(jweString);
        return JweHelper.extractJwsFromJweToken(jweString, config, mpConfigProps, jweHeaderParameters);
    }

    public static String extractJwsFromJweToken(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps, JwtClaims jweHeaderParameters) throws InvalidTokenException {
        String payload = JweHelper.extractPayloadFromJweToken(jweString, config, mpConfigProps, jweHeaderParameters);
        if (!JweHelper.isJws(payload)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"NESTED_JWS_REQUIRED_BUT_NOT_FOUND", (Object[])new Object[0]);
            throw new InvalidTokenException(errorMsg);
        }
        return payload;
    }

    public static String extractPayloadFromJweToken(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws InvalidTokenException {
        JwtClaims jweHeaderParameters = JweHelper.getJweHeaderParams(jweString);
        return JweHelper.extractPayloadFromJweToken(jweString, config, mpConfigProps, jweHeaderParameters);
    }

    @FFDCIgnore(value={Exception.class})
    public static String extractPayloadFromJweToken(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps, JwtClaims jweHeaderParameters) throws InvalidTokenException {
        String payload = null;
        try {
            payload = JweHelper.getJwePayload(jweString, config, mpConfigProps, jweHeaderParameters);
        }
        catch (Exception e) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"ERROR_EXTRACTING_JWS_PAYLOAD_FROM_JWE", (Object[])new Object[]{config.getId(), e});
            throw new InvalidTokenException(errorMsg, e);
        }
        return payload;
    }

    static String getJwePayload(String jweString, JwtConsumerConfig config, MpConfigProperties mpConfigProps, JwtClaims jweHeaderParameters) throws Exception {
        Key decryptionKey = JweHelper.getJweDecryptionKey(config, mpConfigProps, (String)jweHeaderParameters.getClaimValue("kid"));
        if (decryptionKey == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWE_DECRYPTION_KEY_MISSING", (Object[])new Object[]{"keyManagementKeyAlias", config.getKeyManagementKeyAlias()});
            throw new InvalidTokenException(errorMsg);
        }
        return JweHelper.getJwePayload(jweString, decryptionKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getJwePayload(String jweString, @Sensitive Key decryptionKey) throws JoseException, InvalidTokenException {
        JsonWebEncryption jwe = new JsonWebEncryption();
        jwe.setCompactSerialization(jweString);
        jwe.setKey(decryptionKey);
        String payload = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            payload = jwe.getPayload();
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        if (JweHelper.isJws(payload)) {
            JweHelper.verifyContentType(jwe);
        }
        return payload;
    }

    static void verifyContentType(JsonWebEncryption jwe) throws InvalidTokenException {
        String requiredContentType = "JWT";
        String cty = jwe.getContentTypeHeaderValue();
        if (cty == null || !requiredContentType.equalsIgnoreCase(cty)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"CTY_NOT_JWT_FOR_NESTED_JWS", (Object[])new Object[]{"\"cty\"", cty, "\"" + requiredContentType + "\""});
            throw new InvalidTokenException(errorMsg);
        }
    }

    @FFDCIgnore(value={Exception.class})
    public static JwtClaims getJweHeaderParams(String jweString) {
        JwtClaims jweHeaderParameters;
        block2: {
            jweHeaderParameters = null;
            try {
                String headerString = jweString.substring(0, jweString.indexOf(46));
                headerString = new String(Base64.decode((String)headerString));
                jweHeaderParameters = JwtClaims.parse((String)headerString);
            }
            catch (Exception e) {
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting header from JWE string: " + e), (Object[])new Object[0]);
            }
        }
        return jweHeaderParameters == null ? new JwtClaims() : jweHeaderParameters;
    }

    String getKidFromJweString(String jweString) {
        JwtClaims jweHeaderParameters = JweHelper.getJweHeaderParams(jweString);
        return (String)jweHeaderParameters.getClaimValue("kid");
    }

    static void setJweKeyData(JsonWebEncryption jwe, BuilderImpl builder, JwtConfig jwtConfig) throws KeyStoreException, CertificateException, InvalidTokenException {
        Key keyManagementKey = JweHelper.getKeyManagementKey(builder, jwtConfig);
        if (keyManagementKey == null) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"KEY_MANAGEMENT_KEY_NOT_FOUND", (Object[])new Object[]{jwtConfig.getId(), jwtConfig.getKeyManagementKeyAlias(), jwtConfig.getTrustStoreRef()});
            throw new KeyStoreException(errorMsg);
        }
        jwe.setKey(keyManagementKey);
        JweHelper.setJweKidHeader(jwe, keyManagementKey);
    }

    static Key getKeyManagementKey(BuilderImpl builder, JwtConfig jwtConfig) throws KeyStoreException, CertificateException, InvalidTokenException {
        Key keyManagementKey = builder.getKeyManagementKey();
        if (keyManagementKey == null) {
            keyManagementKey = JweHelper.getKeyManagementKeyFromTrustStore(jwtConfig);
        }
        return keyManagementKey;
    }

    static PublicKey getKeyManagementKeyFromTrustStore(JwtConfig jwtConfig) throws KeyStoreException, CertificateException, InvalidTokenException {
        String keyAlias = jwtConfig.getKeyManagementKeyAlias();
        String trustStoreRef = jwtConfig.getTrustStoreRef();
        return JwtUtils.getPublicKey(keyAlias, trustStoreRef);
    }

    @Sensitive
    static Key getJweDecryptionKey(JwtConsumerConfig config, MpConfigProperties mpConfigProps, String kid) throws Exception {
        Key key = config.getJweDecryptionKey();
        if (key != null) {
            return key;
        }
        return JweHelper.getJweDecryptionKeyFromMpConfigProps(config, mpConfigProps, kid);
    }

    @Sensitive
    private static Key getJweDecryptionKeyFromMpConfigProps(JwtConsumerConfig config, MpConfigProperties mpConfigProps, String kid) throws Exception {
        if (mpConfigProps == null) {
            return null;
        }
        String keyLocation = (String)mpConfigProps.get("mp.jwt.decrypt.key.location");
        JweHelper.checkDecryptKeyLocationForInlineKey(keyLocation);
        JwKRetriever jwkRetriever = new JwKRetriever(config.getJwkSet());
        jwkRetriever.setSignatureAlgorithm(mpConfigProps.getConfiguredSignatureAlgorithm(config));
        jwkRetriever.setKeyLocation(keyLocation);
        return jwkRetriever.getPrivateKeyFromJwk(kid, config.getUseSystemPropertiesForHttpClientConnections());
    }

    static void checkDecryptKeyLocationForInlineKey(@Sensitive String location) throws KeyException {
        if (location == null || location.isEmpty()) {
            return;
        }
        if (location.contains("BEGIN ")) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"DECRYPT_KEY_LOCATION_INLINE_KEY", (Object[])new Object[]{"mp.jwt.decrypt.key.location"});
            throw new KeyException(errorMsg);
        }
    }

    static void setJweKidHeader(JsonWebEncryption jwe, Key keyManagementKey) {
        JwkKidBuilder kidbuilder = new JwkKidBuilder();
        String keyId = kidbuilder.buildKeyId(keyManagementKey);
        if (keyId != null) {
            jwe.setKeyIdHeaderValue(keyId);
        }
    }

    static void setJweHeaders(JsonWebEncryption jwe, BuilderImpl builder, JwtConfig jwtConfig) {
        jwe.setAlgorithmHeaderValue(JweHelper.getKeyManagementKeyAlgorithm(builder, jwtConfig));
        jwe.setEncryptionMethodHeaderParameter(JweHelper.getContentEncryptionAlgorithm(builder, jwtConfig));
        jwe.setHeader("typ", "JOSE");
        jwe.setHeader("cty", "jwt");
    }

    static String getKeyManagementKeyAlgorithm(BuilderImpl builder, JwtConfig jwtConfig) {
        String keyManagementAlg = builder.getKeyManagementAlg();
        if (keyManagementAlg == null) {
            keyManagementAlg = JweHelper.getKeyManagementKeyAlgFromConfig(jwtConfig);
        }
        return keyManagementAlg;
    }

    static String getKeyManagementKeyAlgFromConfig(JwtConfig jwtConfig) {
        String configuredKeyManagementAlg = jwtConfig.getKeyManagementKeyAlgorithm();
        if (configuredKeyManagementAlg == null) {
            String string = configuredKeyManagementAlg = CryptoUtils.isFips140_3Enabled() ? "ECDH-ES" : "RSA-OAEP";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Key management algorithm not specified in server config. Defaulting to [" + configuredKeyManagementAlg + "]"), (Object[])new Object[0]);
            }
        }
        return configuredKeyManagementAlg;
    }

    static String getContentEncryptionAlgorithm(BuilderImpl builder, JwtConfig jwtConfig) {
        String contentEncryptionAlg = builder.getContentEncryptionAlg();
        if (contentEncryptionAlg == null) {
            contentEncryptionAlg = JweHelper.getContentEncryptionAlgorithmFromConfig(jwtConfig);
        }
        return contentEncryptionAlg;
    }

    static String getContentEncryptionAlgorithmFromConfig(JwtConfig jwtConfig) {
        String configuredContentEncryptionAlg = jwtConfig.getContentEncryptionAlgorithm();
        if (configuredContentEncryptionAlg == null) {
            configuredContentEncryptionAlg = "A256GCM";
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Content encryption algorithm not specified in server config. Defaulting to [" + configuredContentEncryptionAlg + "]"), (Object[])new Object[0]);
            }
        }
        return configuredContentEncryptionAlg;
    }

    /*
     * WARNING - void declaration
     */
    static String getJwtString(JsonWebEncryption jwe) throws JwtTokenException {
        String jwt = null;
        Object token = ThreadIdentityManager.runAsServer();
        try {
            jwt = jwe.getCompactSerialization();
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.utils.JweHelper", (String)"332", null, (Object[])new Object[]{jwe});
            throw new JwtTokenException(e.getLocalizedMessage(), (Exception)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return jwt;
    }
}

