/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class VirtualHostMapper {
    private static final String CLASSNAME = VirtualHostMapper.class.getName();
    private static final TraceComponent tc = Tr.register((String)CLASSNAME, (String)"Runtime");
    protected Map vHostTable = new ConcurrentHashMap();

    public void addMapping(String path, Object target) {
        this.vHostTable.put(this.normalize(path), target);
    }

    private String normalize(String alias) {
        String regExp = alias.replaceAll("[\\.]", "\\\\\\.");
        regExp = regExp.replaceAll("[*]", "\\.\\*");
        return regExp;
    }

    public void removeMapping(String key) {
        this.vHostTable.remove(this.normalize(key));
    }

    public Iterator targetMappings() {
        Collection vHosts = this.vHostTable.values();
        ArrayList l = new ArrayList();
        l.addAll(vHosts);
        return l.listIterator();
    }

    public Object replaceMapping(String path, Object target) throws Exception {
        return null;
    }

    public Object getMapping(String vHostKey) {
        Iterator i = this.vHostTable.keySet().iterator();
        String bestMatchingPattern = null;
        int bestMatchingPatternLength = -1;
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!vHostKey.matches(pattern)) continue;
                if (vHostKey.equals(pattern)) {
                    bestMatchingPattern = pattern;
                    break;
                }
                if (pattern.equals("_ws_eh.*")) {
                    bestMatchingPattern = pattern;
                    break;
                }
                if (bestMatchingPattern == null) {
                    bestMatchingPattern = pattern;
                    bestMatchingPatternLength = pattern.length();
                    continue;
                }
                if (pattern.length() < bestMatchingPatternLength) continue;
                bestMatchingPattern = pattern;
                bestMatchingPatternLength = pattern.length();
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught an exception in getMapping():", (Object)e);
                }
                return null;
            }
        }
        if (bestMatchingPattern != null) {
            return this.vHostTable.get(bestMatchingPattern);
        }
        return null;
    }

    public boolean exists(String path) {
        Iterator i = this.vHostTable.keySet().iterator();
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!path.matches(pattern)) continue;
                return true;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught an exception in exists():", (Object)e);
                }
                return false;
            }
        }
        return false;
    }

    public boolean exactMatchExists(String path) {
        String _path = this.normalize(path);
        Iterator i = this.vHostTable.keySet().iterator();
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!_path.equals(pattern)) continue;
                return true;
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught an exception in getMapping():", (Object)e);
                }
                return false;
            }
        }
        return false;
    }

    protected Object findExactMatch(String path) {
        String _path = this.normalize(path);
        Iterator i = this.vHostTable.keySet().iterator();
        while (i.hasNext()) {
            try {
                String pattern = (String)i.next();
                if (!_path.equals(pattern)) continue;
                return this.vHostTable.get(pattern);
            }
            catch (Exception e) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Caught an exception in getMapping():", (Object)e);
                }
                return null;
            }
        }
        return null;
    }
}

