/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.cache.CacheServiceImpl;
import com.ibm.wsspi.cache.CacheProvider;
import com.ibm.wsspi.cache.CacheProviderLoader;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CacheProviderLoaderImpl
implements CacheProviderLoader {
    private static TraceComponent tc = Tr.register(CacheProviderLoaderImpl.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    private List<CacheServiceImpl> cacheServices = new LinkedList<CacheServiceImpl>();
    static CacheProviderLoaderImpl cacheLoader = null;

    private CacheProviderLoaderImpl() {
    }

    public static synchronized CacheProviderLoaderImpl getInstance() {
        if (null == cacheLoader) {
            cacheLoader = new CacheProviderLoaderImpl();
        }
        return cacheLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CacheProvider getCacheProvider(String name) {
        List<CacheServiceImpl> list = this.cacheServices;
        synchronized (list) {
            for (CacheServiceImpl csi : this.cacheServices) {
                if (!csi.getCacheConfig().getCacheProviderName().equals(name)) continue;
                return csi.getCacheProvider();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, CacheProvider> getCacheProviders() {
        HashMap<String, CacheProvider> providers = new HashMap<String, CacheProvider>(this.cacheServices.size());
        List<CacheServiceImpl> list = this.cacheServices;
        synchronized (list) {
            for (CacheServiceImpl csi : this.cacheServices) {
                providers.put(csi.getCacheConfig().getCacheProviderName(), csi.getCacheProvider());
            }
        }
        return providers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCacheProvider(CacheServiceImpl cacheServiceImpl) {
        List<CacheServiceImpl> list = this.cacheServices;
        synchronized (list) {
            this.cacheServices.add(cacheServiceImpl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCacheProvider(CacheServiceImpl cacheServiceImpl) {
        List<CacheServiceImpl> list = this.cacheServices;
        synchronized (list) {
            this.cacheServices.remove(cacheServiceImpl);
        }
    }
}

