/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.ui.internal.v1.pojo;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ui.internal.RequestNLS;
import com.ibm.ws.ui.internal.v1.ITool;
import com.ibm.ws.ui.internal.validation.InvalidToolException;

@TraceOptions(messageBundle="com.ibm.ws.ui.internal.resources.ValidationStrings")
public class ToolEntry
implements ITool {
    private static final transient TraceComponent tc = Tr.register(ToolEntry.class);
    static final int MAX_LENGTH = Integer.MAX_VALUE;
    String id;
    String type;

    @Trivial
    ToolEntry() {
    }

    @Trivial
    public ToolEntry(String id, String type) {
        this.id = id;
        this.type = type;
    }

    @Trivial
    private void setId(String id) {
        this.id = id;
    }

    @Override
    @Trivial
    public String getId() {
        return this.id;
    }

    @Trivial
    private void setType(String type) {
        this.type = type;
    }

    @Override
    @Trivial
    public String getType() {
        return this.type;
    }

    @Trivial
    void addTo(StringBuilder sb, String thing) {
        if (sb.length() != 0) {
            sb.append(", ");
        }
        sb.append(thing);
    }

    @Trivial
    private String listNullFields() {
        StringBuilder sb = new StringBuilder();
        if (this.id == null || this.id.trim().isEmpty()) {
            this.addTo(sb, "id");
        }
        if (this.type == null || this.type.trim().isEmpty()) {
            this.addTo(sb, "type");
        }
        return sb.toString();
    }

    @Trivial
    private boolean isRecognizedType(String type) {
        return "featureTool".equals(type) || "bookmark".equals(type);
    }

    @Override
    public void validateSelf() throws InvalidToolException {
        String badRQDfields = this.listNullFields();
        if (badRQDfields.length() != 0) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "RQD_FIELDS_MISSING", badRQDfields));
        }
        if (!this.isRecognizedType(this.type)) {
            throw new InvalidToolException(RequestNLS.formatMessage(tc, "TYPE_NOT_VALID", this.type));
        }
    }

    @Trivial
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ToolEntry) {
            ToolEntry that = (ToolEntry)o;
            boolean sameFields = true;
            sameFields &= this.id == that.id || this.getId() != null && this.getId().equals(that.id);
            return sameFields &= this.type == that.type || this.type != null && this.type.equals(that.type);
        }
        return false;
    }

    @Trivial
    public int hashCode() {
        return this.id == null ? 0 : this.id.hashCode();
    }

    @Trivial
    String getJSONString(String str) {
        if (str == null) {
            return "null";
        }
        return "\"" + str + "\"";
    }

    @Trivial
    public String toString() {
        StringBuilder sb = new StringBuilder("ToolEntry {\"id\":");
        sb.append(this.getJSONString(this.id));
        sb.append(",\"type\":");
        sb.append(this.getJSONString(this.type));
        sb.append("}");
        return sb.toString();
    }
}

