/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sip.stack.transaction.transport.routers;

import com.ibm.sip.util.log.Log;
import com.ibm.sip.util.log.LogMgr;
import com.ibm.ws.sip.stack.transaction.transport.Hop;
import com.ibm.ws.sip.stack.transaction.transport.routers.SLSPRouter;
import jain.protocol.ip.sip.SipParseException;
import jain.protocol.ip.sip.address.SipURL;
import jain.protocol.ip.sip.header.HeaderIterator;
import jain.protocol.ip.sip.header.ViaHeader;
import jain.protocol.ip.sip.message.Request;
import java.util.HashMap;
import java.util.HashSet;

public class SLSPAffinityRouter
extends SLSPRouter {
    private static final LogMgr c_logger = Log.get(SLSPAffinityRouter.class);
    private HashMap m_userAddressToConnectionTable = new HashMap();
    private HashMap m_connectionToUserAddressTable = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processRequest(Request request) throws SipParseException {
        super.processRequest(request);
        Hop slspHop = null;
        HashSet<Hop> dependants = null;
        HeaderIterator viaHeaders = request.getViaHeaders();
        SLSPAffinityRouter sLSPAffinityRouter = this;
        synchronized (sLSPAffinityRouter) {
            while (viaHeaders.hasNext()) {
                ViaHeader via = (ViaHeader)viaHeaders.next();
                Hop hop = new Hop(via);
                if (slspHop == null && (dependants = (HashSet)this.m_connectionToUserAddressTable.get(slspHop = hop)) == null) {
                    dependants = new HashSet<Hop>();
                    this.m_connectionToUserAddressTable.put(slspHop, dependants);
                }
                dependants.add(hop);
                this.m_userAddressToConnectionTable.put(hop, slspHop);
            }
        }
    }

    @Override
    public synchronized void removeConnectionHop(Hop connectionHop) {
        super.removeConnectionHop(connectionHop);
        HashSet dependants = (HashSet)this.m_connectionToUserAddressTable.remove(connectionHop);
        if (dependants != null) {
            for (Hop hop : dependants) {
                this.m_userAddressToConnectionTable.remove(hop);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Hop getNextHop(SipURL url) {
        Hop slsp;
        Hop target = Hop.getHop(url);
        SLSPAffinityRouter sLSPAffinityRouter = this;
        synchronized (sLSPAffinityRouter) {
            slsp = (Hop)this.m_userAddressToConnectionTable.get(target);
            if (slsp == null && (slsp = super.getNextHop(url)) != null) {
                this.m_userAddressToConnectionTable.put(target, slsp);
            }
        }
        return slsp;
    }

    @Override
    public synchronized void addSLSP(Hop slsp) {
        if (!this.m_connectionToUserAddressTable.containsKey(slsp)) {
            HashSet dependants = new HashSet();
            this.m_connectionToUserAddressTable.put(slsp, dependants);
        }
        super.addSLSP(slsp);
    }

    @Override
    public synchronized void removeSLSP(Hop slsp) {
        this.removeConnectionHop(slsp);
    }

    @Override
    public synchronized void removeSLSPs() {
        this.m_connectionToUserAddressTable.clear();
        this.m_userAddressToConnectionTable.clear();
        super.removeSLSPs();
    }
}

