/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.pkce;

import com.ibm.oauth.core.api.error.oauth20.InvalidGrantException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.pkce.ProofKeyForCodeExchangeMethod;
import com.ibm.ws.security.oauth20.util.HashUtils;
import java.nio.charset.StandardCharsets;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class PkceMethodS256
extends ProofKeyForCodeExchangeMethod {
    private static final TraceComponent tc = Tr.register(PkceMethodS256.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.resources.ProviderMsgs");
    public static String CHALLENGE_METHOD = "S256";
    public static String CODE_CHALLENGE_ALG_METHOD = "SHA-256";
    static final long serialVersionUID = -6028844981170068637L;

    @Override
    public String getCodeChallengeMethod() {
        return CHALLENGE_METHOD;
    }

    @Override
    public String generateCodeChallenge(String codeVerifier) {
        return HashUtils.encodedDigest(codeVerifier, CODE_CHALLENGE_ALG_METHOD, StandardCharsets.US_ASCII);
    }

    @Override
    public void validate(String codeVerifier, String codeChallenge) throws InvalidGrantException {
        if (codeVerifier == null && codeChallenge == null) {
            return;
        }
        String derivedCodeChallenge = this.generateCodeChallenge(codeVerifier);
        if (codeChallenge == null && codeVerifier != null || !codeChallenge.equals(derivedCodeChallenge)) {
            String message = Tr.formatMessage((TraceComponent)tc, (String)"security.oauth20.pkce.error.mismatch.codeverifier", (Object[])new Object[]{codeChallenge, codeVerifier});
            throw new InvalidGrantException(message, null);
        }
    }
}

