/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.metrics.internal.monitor.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.eclipse.microprofile.metrics.Gauge;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MonitorGauge<T extends Number>
implements Gauge<T> {
    private static final TraceComponent tc = Tr.register(MonitorGauge.class, (String)"METRICS", (String)"com.ibm.ws.microprofile.metrics.resources.Metrics");
    MBeanServer mbs;
    String objectName;
    String attribute;
    String subAttribute;
    boolean isComposite = false;
    static final long serialVersionUID = -7871057386739985544L;

    public MonitorGauge(MBeanServer mbs, String objectName, String attribute) {
        this.mbs = mbs;
        this.objectName = objectName;
        this.attribute = attribute;
    }

    public MonitorGauge(MBeanServer mbs, String objectName, String attribute, String subAttribute) {
        this.mbs = mbs;
        this.objectName = objectName;
        this.attribute = attribute;
        this.subAttribute = subAttribute;
        this.isComposite = true;
    }

    /*
     * WARNING - void declaration
     */
    public T getValue() {
        try {
            if (this.isComposite) {
                CompositeData value = (CompositeData)this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
                return (T)((Number)value.get(this.subAttribute));
            }
            Number value = (Number)this.mbs.getAttribute(new ObjectName(this.objectName), this.attribute);
            return (T)value;
        }
        catch (Exception value) {
            FFDCFilter.processException((Throwable)value, (String)"io.openliberty.microprofile.metrics.internal.monitor.internal.MonitorGauge", (String)"56", (Object)this, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"getValue exception message: ", (Object[])new Object[]{e.getMessage()});
                FFDCFilter.processException((Throwable)e, (String)this.getClass().getSimpleName(), (String)"getValue:Exception");
            }
            return null;
        }
    }
}

